/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.api;

import com.github.nickrm.jflux.api.InfluxHttpService;
import com.github.nickrm.jflux.api.InfluxRequestInterceptor;
import com.github.nickrm.jflux.api.converter.ApiResponseConverter;
import com.github.nickrm.jflux.api.exception.IllegalStatementException;
import com.github.nickrm.jflux.api.exception.InfluxClientException;
import com.github.nickrm.jflux.api.response.ApiResponse;
import com.github.nickrm.jflux.api.response.QueryResult;
import com.github.nickrm.jflux.api.response.ResponseMetadata;
import com.github.nickrm.jflux.domain.Measurement;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class JFluxHttpClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JFluxHttpClient.class);
    private static final Pattern MULTI_SERIES_PATTERN = Pattern.compile("SELECT .* FROM .+,.+");
    private static final Pattern SELECT_INTO_PATTERN = Pattern.compile("SELECT .* INTO .* FROM .*");
    private static final MediaType LINE_PROTOCOL_MEDIA_TYPE = MediaType.get((String)"application/octet-stream");
    private final InfluxHttpService service;
    private final ApiResponseConverter responseConverter;
    private String hostUrl;

    private JFluxHttpClient(InfluxHttpService service, ApiResponseConverter responseConverter) {
        this.service = service;
        this.responseConverter = responseConverter;
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    public ResponseMetadata ping() throws IOException {
        Call<ResponseBody> call = this.service.ping();
        Response response = call.execute();
        return this.responseConverter.convert((Response<ResponseBody>)response).getMetadata();
    }

    public Measurement query(String query) throws IOException {
        if (MULTI_SERIES_PATTERN.matcher(query).matches()) {
            throw new IllegalStatementException("Query cannot span multiple measurements");
        }
        List<Measurement> measurements = this.queryMultipleSeries(query).getResults();
        return measurements.isEmpty() ? null : measurements.get(0);
    }

    public QueryResult queryMultipleSeries(String query) throws IOException {
        if (query.contains(";")) {
            throw new IllegalStatementException("Query cannot contain multiple statements");
        }
        return this.batchQuery(query).getResults().get(0);
    }

    public ApiResponse batchQuery(String query) throws IOException {
        if (SELECT_INTO_PATTERN.matcher(query).matches()) {
            throw new IllegalStatementException("Cannot execute 'SELECT INTO' as query");
        }
        ApiResponse response = this.callApi(this.service::query, query);
        LOGGER.debug("Received {}", (Object)response);
        return response;
    }

    public void execute(String statement) throws IOException {
        this.callApi(this.service::alter, statement);
    }

    public ApiResponse write(String database, String lineProtocol) throws IOException {
        LOGGER.debug("Writing line '{}' to {}", (Object)lineProtocol, (Object)database);
        RequestBody requestBody = RequestBody.create((MediaType)LINE_PROTOCOL_MEDIA_TYPE, (String)lineProtocol);
        return this.callApi(() -> this.service.write(database, requestBody));
    }

    public ApiResponse write(String database, String retentionPolicy, String lineProtocol) throws IOException {
        LOGGER.debug("Writing line '{}' to {}.{}", new Object[]{lineProtocol, database, retentionPolicy});
        RequestBody requestBody = RequestBody.create((MediaType)LINE_PROTOCOL_MEDIA_TYPE, (String)lineProtocol);
        return this.callApi(() -> this.service.write(database, retentionPolicy, requestBody));
    }

    private ApiResponse callApi(Function<String, Call<ResponseBody>> apiMethod, String statement) throws IOException {
        LOGGER.debug("Executing statement '{}'", (Object)statement);
        return this.callApi(() -> (Call)apiMethod.apply(statement));
    }

    private ApiResponse callApi(Supplier<Call<ResponseBody>> apiMethod) throws IOException {
        Call<ResponseBody> call = apiMethod.get();
        Response responseWrapper = call.execute();
        LOGGER.debug("Received response: {}", (Object)responseWrapper);
        ApiResponse response = this.responseConverter.convert((Response<ResponseBody>)responseWrapper);
        if (response.hasError()) {
            throw new InfluxClientException(response.getErrorMessage());
        }
        return response;
    }

    @Override
    public void close() {
    }

    public static final class Builder {
        private String host;

        public Builder(String host) {
            this.host = host;
        }

        public JFluxHttpClient build() {
            OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new InfluxRequestInterceptor()).build();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(this.host).client(okHttpClient).build();
            InfluxHttpService service = (InfluxHttpService)retrofit.create(InfluxHttpService.class);
            JFluxHttpClient client = new JFluxHttpClient(service, new ApiResponseConverter());
            client.hostUrl = this.host;
            return client;
        }
    }
}

