/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux;

import com.github.nickrm.jflux.DurationConverter;
import com.github.nickrm.jflux.domain.Point;
import com.github.nickrm.jflux.domain.RetentionPolicy;
import java.time.Duration;

final class RetentionPolicyConverter {
    private final DurationConverter durationConverter = new DurationConverter();

    RetentionPolicyConverter() {
    }

    RetentionPolicy parsePoint(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("Point cannot be null");
        }
        String retentionPolicyName = point.getTags().get("name");
        Duration duration = this.durationConverter.parseDuration(point.getTags().get("duration"));
        int replication = Integer.parseInt(String.valueOf(point.getFields().get("replicaN")));
        Duration shardDuration = this.durationConverter.parseDuration(point.getTags().get("shardGroupDuration"));
        boolean isDefault = Boolean.parseBoolean(String.valueOf(point.getFields().get("default")));
        return new RetentionPolicy.Builder(retentionPolicyName, duration).replication(replication).shardDuration(shardDuration).isDefault(isDefault).build();
    }
}

