/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux;

import com.github.nickrm.jflux.domain.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LineProtocolConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineProtocolConverter.class);

    LineProtocolConverter() {
    }

    List<String> toLineProtocol(String measurementName, Collection<Point> points) {
        if (StringUtils.isBlank((CharSequence)measurementName)) {
            throw new IllegalArgumentException("Measurement name cannot be blank");
        }
        HashMap<String, Collection> series = new HashMap<String, Collection>();
        points.forEach(point -> {
            HashMap escapedTags = new HashMap();
            point.getTags().forEach((tagName, tagValue) -> {
                String escapedValue = tagValue.replaceAll("\\s", "\\\\ ");
                escapedTags.put(tagName, escapedValue);
            });
            String tagSet = this.collectKeyValuePairs(escapedTags);
            series.computeIfAbsent(tagSet, key -> new ArrayList()).add(point);
        });
        LOGGER.debug("Found {} tag sets: {}", (Object)series.size(), series.keySet());
        ArrayList<String> lineProtocols = new ArrayList<String>();
        series.forEach((tagSet, seriesPoints) -> {
            String lineProtocol = this.toLineProtocol(measurementName, (String)tagSet, (Collection<Point>)seriesPoints);
            lineProtocols.add(lineProtocol);
        });
        return lineProtocols;
    }

    private String toLineProtocol(String measurementName, String tagSet, Collection<Point> points) {
        StringBuilder lineProtocol = new StringBuilder();
        lineProtocol.append(measurementName);
        if (!tagSet.isEmpty()) {
            lineProtocol.append(',').append(tagSet);
        }
        StringJoiner pointStringJoiner = new StringJoiner("\n");
        points.forEach(point -> {
            String fieldSet = this.collectKeyValuePairs(point.getFields());
            if (point.getTimestamp() != null) {
                fieldSet = fieldSet + " " + point.getTimestamp().toEpochMilli();
            }
            pointStringJoiner.add(fieldSet);
        });
        lineProtocol.append(' ').append(pointStringJoiner.toString());
        return lineProtocol.toString();
    }

    private String collectKeyValuePairs(Map<String, ?> map) {
        return map.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(","));
    }
}

