/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;

final class DurationConverter {
    private static final int FULL_FORMAT_PARTS = 3;

    DurationConverter() {
    }

    Duration parseDuration(String durationLiteral) {
        if (StringUtils.isBlank((CharSequence)durationLiteral)) {
            throw new IllegalArgumentException("Duration literal cannot be blank");
        }
        String[] values = durationLiteral.split("[hms]");
        long hours = values.length == 3 ? Long.parseLong(values[values.length - 3]) : 0L;
        long minutes = values.length >= 2 ? Long.parseLong(values[values.length - 2]) : 0L;
        long seconds = Long.parseLong(values[values.length - 1]);
        return Duration.ofHours(hours).plusMinutes(minutes).plusSeconds(seconds);
    }

    String toLiteral(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Duration cannot be null");
        }
        if (duration.isNegative()) {
            throw new IllegalArgumentException("Duration cannot be negative");
        }
        if (duration.isZero()) {
            return "0s";
        }
        long hours = duration.toHours();
        long minutes = duration.minusHours(hours).toMinutes();
        long seconds = duration.minusHours(hours).minusMinutes(minutes).getSeconds();
        return (hours > 0L ? hours + "h" : "") + (minutes > 0L ? minutes + "m" : "") + (seconds > 0L ? seconds + "s" : "");
    }
}

