/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux;

import com.github.nickrm.jflux.NamingStrategy;
import com.github.nickrm.jflux.annotation.Field;
import com.github.nickrm.jflux.annotation.Tag;
import com.github.nickrm.jflux.annotation.Timestamp;
import com.github.nickrm.jflux.annotation.exception.AnnotationProcessingException;
import com.github.nickrm.jflux.annotation.exception.DuplicateAnnotatedMembersException;
import com.github.nickrm.jflux.annotation.exception.InvalidAnnotatedType;
import com.github.nickrm.jflux.annotation.exception.MissingAnnotatedMemberException;
import com.github.nickrm.jflux.domain.Point;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;

final class AnnotationBasedPointConverter {
    private final NamingStrategy namingStrategy;

    AnnotationBasedPointConverter(NamingStrategy namingStrategy) {
        if (namingStrategy == null) {
            throw new IllegalArgumentException("Naming strategy cannot be null");
        }
        this.namingStrategy = namingStrategy;
    }

    Point toPoint(Object annotatedObject) {
        if (annotatedObject == null) {
            throw new IllegalArgumentException("Annotated object cannot be null");
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        HashMap<String, String> tags = new HashMap<String, String>();
        for (java.lang.reflect.Field field : annotatedObject.getClass().getDeclaredFields()) {
            Object fieldValue = this.getInstanceFieldValue(annotatedObject, field, Object.class);
            if (fieldValue == null || !field.isAnnotationPresent(Field.class) && !field.isAnnotationPresent(Tag.class)) continue;
            if (field.isAnnotationPresent(Field.class)) {
                if (!(fieldValue instanceof Number) && !(fieldValue instanceof Boolean)) {
                    throw new InvalidAnnotatedType((Member)field, Arrays.asList(Number.class, Boolean.class));
                }
                fields.put(this.namingStrategy.getFieldName(field), fieldValue);
                continue;
            }
            tags.put(this.namingStrategy.getTagName(field), fieldValue.toString());
        }
        if (fields.isEmpty()) {
            throw new MissingAnnotatedMemberException(annotatedObject, Field.class);
        }
        Instant timestamp = this.getTimestamp(annotatedObject);
        return new Point.Builder().timestamp(timestamp).fields(fields).tags(tags).build();
    }

    private Instant getTimestamp(Object o) {
        java.lang.reflect.Field timestampField = Arrays.stream(o.getClass().getDeclaredFields()).filter(member -> member.isAnnotationPresent(Timestamp.class)).reduce((a, b) -> {
            throw new DuplicateAnnotatedMembersException(o, Timestamp.class);
        }).orElse(null);
        if (timestampField == null) {
            return null;
        }
        return this.getInstanceFieldValue(o, timestampField, Instant.class);
    }

    private <T> T getInstanceFieldValue(Object o, java.lang.reflect.Field field, Class<T> type) {
        Object value;
        try {
            field.setAccessible(true);
            value = field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new AnnotationProcessingException("Could not get field value", e);
        }
        finally {
            field.setAccessible(false);
        }
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        throw new InvalidAnnotatedType((Member)field, type);
    }

    <T> T fromPoint(Point point, Class<T> targetType) {
        if (point == null) {
            throw new IllegalArgumentException("Point cannot be null");
        }
        if (targetType == null) {
            throw new IllegalArgumentException("Target type cannot be null");
        }
        T targetInstance = this.createInstance(targetType);
        for (java.lang.reflect.Field field : targetType.getDeclaredFields()) {
            this.setFieldValue(point, targetInstance, field);
        }
        return targetInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T createInstance(Class<T> targetType) {
        try {
            Constructor<T> ctor = targetType.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            try {
                T t = ctor.newInstance(new Object[0]);
                return t;
            }
            finally {
                ctor.setAccessible(false);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AnnotationProcessingException("Could not instantiate target class", e);
        }
    }

    private <T> void setFieldValue(Point point, T targetInstance, java.lang.reflect.Field field) {
        try {
            Object value;
            if (field.isAnnotationPresent(Timestamp.class)) {
                value = point.getTimestamp();
            } else if (field.isAnnotationPresent(Field.class)) {
                String fieldName = this.namingStrategy.getFieldName(field);
                value = point.getFields().get(fieldName);
            } else if (field.isAnnotationPresent(Tag.class)) {
                String tagName = this.namingStrategy.getTagName(field);
                value = point.getTags().get(tagName);
            } else {
                return;
            }
            field.setAccessible(true);
            try {
                field.set(targetInstance, value);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidAnnotatedType((Member)field, value.getClass());
            }
        }
        catch (IllegalAccessException e) {
            throw new AnnotationProcessingException("Could not set field value", e);
        }
        finally {
            field.setAccessible(false);
        }
    }
}

