/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j;

import com.github.myzhan.locust4j.AbstractTask;
import com.github.myzhan.locust4j.ratelimit.AbstractRateLimiter;
import com.github.myzhan.locust4j.ratelimit.StableRateLimiter;
import com.github.myzhan.locust4j.rpc.ZeromqClient;
import com.github.myzhan.locust4j.runtime.Runner;
import com.github.myzhan.locust4j.stats.RequestFailure;
import com.github.myzhan.locust4j.stats.RequestSuccess;
import com.github.myzhan.locust4j.stats.Stats;
import com.github.myzhan.locust4j.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Locust {
    private static final Logger logger = LoggerFactory.getLogger(Locust.class);
    private String masterHost = Utils.getSystemEnvWithDefault("LOCUST_MASTER_NODE_HOST", "127.0.0.1");
    private int masterPort = Integer.parseInt(Utils.getSystemEnvWithDefault("LOCUST_MASTER_NODE_PORT", "5557"));
    private boolean started = false;
    private boolean verbose = false;
    private boolean rateLimitEnabled;
    private AbstractRateLimiter rateLimiter;
    private Runner runner;

    private Locust() {
    }

    public static Locust getInstance() {
        return InstanceHolder.LOCUST;
    }

    public void setMasterHost(String masterHost) {
        this.masterHost = masterHost;
    }

    public void setMasterPort(int masterPort) {
        this.masterPort = masterPort;
    }

    public void setMaxRPS(long maxRPS) {
        this.rateLimiter = new StableRateLimiter(maxRPS);
        this.setRateLimiter(this.rateLimiter);
    }

    public AbstractRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(AbstractRateLimiter rateLimiter) {
        this.rateLimitEnabled = rateLimiter != null;
        this.rateLimiter = rateLimiter;
    }

    public boolean isRateLimitEnabled() {
        return this.rateLimitEnabled;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    protected void setRunner(Runner runner) {
        this.runner = runner;
    }

    protected Runner getRunner() {
        return this.runner;
    }

    private List<AbstractTask> removeInvalidTasks(List<AbstractTask> tasks) {
        ListIterator<AbstractTask> iter = tasks.listIterator();
        while (iter.hasNext()) {
            if (iter.next().getWeight() >= 0) continue;
            iter.remove();
        }
        return tasks;
    }

    public void run(AbstractTask ... tasks) {
        this.run(Arrays.asList(tasks));
    }

    public synchronized void run(List<AbstractTask> tasks) {
        if (this.started) {
            return;
        }
        this.removeInvalidTasks(tasks);
        Stats.getInstance().start();
        this.runner = new Runner();
        this.runner.setStats(Stats.getInstance());
        ZeromqClient client = new ZeromqClient(this.masterHost, this.masterPort, this.runner.getNodeID());
        this.runner.setRPCClient(client);
        this.runner.setTasks(tasks);
        this.runner.getReady();
        this.addShutdownHook();
        this.started = true;
    }

    public void dryRun(AbstractTask ... tasks) {
        this.dryRun(Arrays.asList(tasks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dryRun(List<AbstractTask> tasks) {
        logger.debug("Running tasks without connecting to master.");
        for (AbstractTask task : tasks) {
            logger.debug("Running task named {} onStart", (Object)task.getName());
            try {
                task.onStart();
            }
            catch (Exception ex) {
                logger.error("Unknown exception when calling onStart", (Throwable)ex);
            }
            logger.debug("Running task named {}", (Object)task.getName());
            try {
                task.execute();
            }
            catch (Exception ex) {
                logger.error("Unknown exception when executing the task", (Throwable)ex);
            }
            finally {
                task.onStop();
            }
        }
    }

    public synchronized void stop() {
        if (this.started) {
            AbstractRateLimiter rateLimiter = this.getRateLimiter();
            if (rateLimiter != null && !rateLimiter.isStopped()) {
                rateLimiter.stop();
            }
            if (this.runner != null) {
                this.runner.quit();
            }
            this.started = false;
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Locust.getInstance().stop();
            }
        });
    }

    public void recordSuccess(String requestType, String name, long responseTime, long contentLength) {
        RequestSuccess success = new RequestSuccess();
        success.setRequestType(requestType);
        success.setName(name);
        success.setResponseTime(responseTime);
        success.setContentLength(contentLength);
        Stats.getInstance().getReportSuccessQueue().offer(success);
        Stats.getInstance().wakeMeUp();
    }

    public void recordFailure(String requestType, String name, long responseTime, String error) {
        RequestFailure failure = new RequestFailure();
        failure.setRequestType(requestType);
        failure.setName(name);
        failure.setResponseTime(responseTime);
        failure.setError(error);
        Stats.getInstance().getReportFailureQueue().offer(failure);
        Stats.getInstance().wakeMeUp();
    }

    public Object getRemoteParam(String key) {
        if (this.runner == null) {
            return null;
        }
        return this.runner.getRemoteParams().get(key);
    }

    private static class InstanceHolder {
        private static final Locust LOCUST = new Locust();

        private InstanceHolder() {
        }
    }
}

