/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.validation.beanvalidation;

import com.github.mygreen.supercsv.localization.MessageResolver;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.MessageInterpolator;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;

public class MessageInterpolatorAdapter
implements MessageInterpolator {
    private final MessageResolver messageResolver;
    private final com.github.mygreen.supercsv.localization.MessageInterpolator csvMessageInterpolator;

    public MessageInterpolatorAdapter(MessageResolver messageResolver, com.github.mygreen.supercsv.localization.MessageInterpolator csvMessageInterpolator) {
        Objects.requireNonNull(messageResolver);
        Objects.requireNonNull(csvMessageInterpolator);
        this.messageResolver = messageResolver;
        this.csvMessageInterpolator = csvMessageInterpolator;
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        return this.csvMessageInterpolator.interpolate(messageTemplate, this.createMessageVariables(context), true, this.messageResolver);
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
        return this.csvMessageInterpolator.interpolate(messageTemplate, this.createMessageVariables(context), true, this.messageResolver);
    }

    private Map<String, Object> createMessageVariables(MessageInterpolator.Context context) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (context instanceof MessageInterpolatorContext) {
            MessageInterpolatorContext mic = (MessageInterpolatorContext)context;
            vars.putAll(mic.getMessageParameters());
        }
        ConstraintDescriptor descriptor = context.getConstraintDescriptor();
        for (Map.Entry entry : descriptor.getAttributes().entrySet()) {
            String attrName = (String)entry.getKey();
            Object attrValue = entry.getValue();
            vars.put(attrName, attrValue);
        }
        vars.computeIfAbsent("validatedValue", key -> context.getValidatedValue());
        String defaultCode = String.format("%s.message", descriptor.getAnnotation().annotationType().getCanonicalName());
        Optional<String> defaultMessage = this.messageResolver.getMessage(defaultCode);
        vars.put(defaultCode, defaultMessage.orElseThrow(() -> new RuntimeException(String.format("not found message code '%s'", defaultCode))));
        return vars;
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    public com.github.mygreen.supercsv.localization.MessageInterpolator getCsvMessageInterpolator() {
        return this.csvMessageInterpolator;
    }
}

