/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.validation.beanvalidation;

import com.github.mygreen.supercsv.builder.ColumnMapping;
import com.github.mygreen.supercsv.validation.CsvBindingErrors;
import com.github.mygreen.supercsv.validation.CsvFieldError;
import com.github.mygreen.supercsv.validation.CsvValidator;
import com.github.mygreen.supercsv.validation.ValidationContext;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.ValidatorImpl;

public class CsvBeanValidator
implements CsvValidator<Object> {
    private static final Set<String> EXCLUDE_MESSAGE_ANNOTATION_ATTRIBUTES;
    private final Validator targetValidator;
    private final MessageInterpolator messageInterpolator;

    public CsvBeanValidator(Validator targetValidator) {
        Objects.requireNonNull(targetValidator);
        this.targetValidator = targetValidator;
        this.messageInterpolator = CsvBeanValidator.getMessageInterpolatorFromValidator(targetValidator);
    }

    public CsvBeanValidator() {
        this.targetValidator = this.createDefaultValidator();
        this.messageInterpolator = CsvBeanValidator.getMessageInterpolatorFromValidator(this.targetValidator);
    }

    private Validator createDefaultValidator() {
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        Validator validator = validatorFactory.usingContext().getValidator();
        return validator;
    }

    private static MessageInterpolator getMessageInterpolatorFromValidator(Validator validator) {
        if (!(validator instanceof ValidatorImpl)) {
            return null;
        }
        try {
            Field field = ValidatorImpl.class.getDeclaredField("messageInterpolator");
            field.setAccessible(true);
            MessageInterpolator interpolator = (MessageInterpolator)field.get(validator);
            return interpolator;
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException("fail reflect MessageInterpolrator from ValidatorImpl.", e);
        }
    }

    public Validator getTargetValidator() {
        return this.targetValidator;
    }

    @Override
    public void validate(Object record, CsvBindingErrors bindingErrors, ValidationContext<Object> validationContext) {
        this.validate(record, bindingErrors, validationContext, validationContext.getBeanMapping().getGroups());
    }

    public void validate(Object record, CsvBindingErrors bindingErrors, ValidationContext<Object> validationContext, Class<?> ... groups) {
        Objects.requireNonNull(record);
        Objects.requireNonNull(bindingErrors);
        Objects.requireNonNull(validationContext);
        this.processConstraintViolation(this.getTargetValidator().validate(record, (Class[])groups), bindingErrors, validationContext);
    }

    private void processConstraintViolation(Set<ConstraintViolation<Object>> violations, CsvBindingErrors bindingErrors, ValidationContext<Object> validationContext) {
        for (ConstraintViolation<Object> violation : violations) {
            String field = violation.getPropertyPath().toString();
            ConstraintDescriptor cd = violation.getConstraintDescriptor();
            String[] errorCodes = this.determineErrorCode(cd);
            Map<String, Object> errorVars = this.createVariableForConstraint(cd);
            if (this.isCsvField(field, validationContext)) {
                CsvFieldError fieldError = bindingErrors.getFirstFieldError(field);
                if (fieldError != null && fieldError.isProcessingFailure()) continue;
                ColumnMapping columnMapping = validationContext.getBeanMapping().getColumnMapping(field).get();
                errorVars.put("lineNumber", validationContext.getCsvContext().getLineNumber());
                errorVars.put("rowNumber", validationContext.getCsvContext().getRowNumber());
                errorVars.put("columnNumber", columnMapping.getNumber());
                errorVars.put("label", columnMapping.getLabel());
                errorVars.computeIfAbsent("printer", key -> columnMapping.getFormatter());
                Object fieldValue = violation.getInvalidValue();
                errorVars.computeIfAbsent("validatedValue", key -> fieldValue);
                String defaultMessage = this.determineDefaltMessage(errorVars, violation);
                bindingErrors.rejectValue(field, columnMapping.getField().getType(), errorCodes, errorVars, defaultMessage);
                continue;
            }
            bindingErrors.reject(errorCodes, errorVars, violation.getMessage());
        }
    }

    protected String[] determineErrorCode(ConstraintDescriptor<?> descriptor) {
        return new String[]{descriptor.getAnnotation().annotationType().getSimpleName()};
    }

    private boolean isCsvField(String field, ValidationContext<Object> validationContext) {
        return validationContext.getBeanMapping().getColumnMapping(field).isPresent();
    }

    private Map<String, Object> createVariableForConstraint(ConstraintDescriptor<?> descriptor) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (Map.Entry entry : descriptor.getAttributes().entrySet()) {
            String attrName = (String)entry.getKey();
            Object attrValue = entry.getValue();
            if (EXCLUDE_MESSAGE_ANNOTATION_ATTRIBUTES.contains(attrName)) continue;
            vars.put(attrName, attrValue);
        }
        return vars;
    }

    protected String determineDefaltMessage(Map<String, Object> errorVars, ConstraintViolation<Object> violation) {
        String message = violation.getMessage();
        if (this.messageInterpolator == null) {
            return message;
        }
        if (!message.contains("{") || !message.contains("}")) {
            return message;
        }
        MessageInterpolatorContext context = new MessageInterpolatorContext(violation.getConstraintDescriptor(), violation.getInvalidValue(), violation.getRootBeanClass(), errorVars, Collections.emptyMap());
        return this.messageInterpolator.interpolate(violation.getMessageTemplate(), (MessageInterpolator.Context)context);
    }

    static {
        HashSet<String> set = new HashSet<String>(3);
        set.add("message");
        set.add("groups");
        set.add("payload");
        EXCLUDE_MESSAGE_ANNOTATION_ATTRIBUTES = Collections.unmodifiableSet(set);
    }
}

