/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.validation;

import com.github.mygreen.supercsv.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class MessageCodeGenerator
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CODE_SEPARATOR = ".";
    private String prefix = "";
    private String typeMismatchCode = "typeMismatch";

    public String[] generateCodes(String code, String objectName) {
        return this.generateCodes(code, objectName, null, null);
    }

    public String[] generateTypeMismatchCodes(String objectName, String field, Class<?> fileType) {
        return this.generateCodes(this.getTypeMismatchCode(), objectName, field, fileType);
    }

    public String[] generateObjectNameCodes(String objectName) {
        Objects.requireNonNull(objectName, "objectName should not be null");
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add(objectName);
        int dotIndex = objectName.lastIndexOf(46);
        if (dotIndex > 0) {
            String subName = objectName.substring(dotIndex + 1);
            codeList.add(subName);
        }
        return codeList.toArray(new String[codeList.size()]);
    }

    public String[] generateFieldNameCodes(String objectName, String field) {
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.addAll(Arrays.asList(this.generateCodes(null, objectName, field, null)));
        int dotIndex = objectName.lastIndexOf(46);
        if (dotIndex > 0) {
            String subName = objectName.substring(dotIndex + 1);
            for (String code : this.generateCodes(null, subName, field, null)) {
                if (codeList.contains(code)) continue;
                codeList.add(code);
            }
        }
        return codeList.toArray(new String[codeList.size()]);
    }

    public String[] generateParentNameCodes(String objectName, String field) {
        if (Utils.isEmpty(field) || !field.contains(CODE_SEPARATOR)) {
            return this.generateObjectNameCodes(objectName);
        }
        int dotIndex = field.lastIndexOf(46);
        String subName = field.substring(0, dotIndex);
        return this.generateFieldNameCodes(objectName, subName);
    }

    public String[] generateCodes(String code, String objectName, String field, Class<?> fieldType) {
        int dotIndex;
        String baseCode = this.getPrefix().isEmpty() ? code : this.getPrefix() + code;
        ArrayList<String> codeList = new ArrayList<String>();
        ArrayList<String> fieldList = new ArrayList<String>();
        this.buildFieldList(field, fieldList);
        this.addCodes(codeList, baseCode, objectName, fieldList);
        if (Utils.isNotEmpty(field) && (dotIndex = field.lastIndexOf(46)) > 0) {
            this.buildFieldList(field.substring(dotIndex + 1), fieldList);
        }
        this.addCodes(codeList, code, null, fieldList);
        if (fieldType != null) {
            this.addCode(codeList, code, null, fieldType.getName());
            if (Enum.class.isAssignableFrom(fieldType)) {
                this.addCode(codeList, code, null, Enum.class.getName());
            }
            if (Number.class.isAssignableFrom(fieldType)) {
                this.addCode(codeList, code, null, Number.class.getName());
            }
        }
        this.addCode(codeList, code, null, null);
        return codeList.toArray(new String[codeList.size()]);
    }

    protected void buildFieldList(String field, List<String> fieldList) {
        if (Utils.isEmpty(field)) {
            return;
        }
        if (!fieldList.contains(field)) {
            fieldList.add(field);
        }
        String plainField = String.valueOf(field);
        int keyIndex = plainField.lastIndexOf(91);
        while (keyIndex >= 0) {
            int endKeyIndex = plainField.indexOf(93, keyIndex);
            if (endKeyIndex >= 0) {
                if (!fieldList.contains(plainField = plainField.substring(0, keyIndex) + plainField.substring(endKeyIndex + 1))) {
                    fieldList.add(plainField);
                }
                keyIndex = plainField.lastIndexOf(91);
                continue;
            }
            keyIndex = -1;
        }
    }

    private void addCodes(List<String> codeList, String code, String objectName, List<String> fieldList) {
        for (String field : fieldList) {
            this.addCode(codeList, code, objectName, field);
        }
    }

    private void addCode(List<String> codeList, String code, String objectName, String field) {
        String formattedCode = this.formatCode(code, objectName, field);
        if (!codeList.contains(formattedCode)) {
            codeList.add(formattedCode);
        }
    }

    private String formatCode(String ... elements) {
        StringBuilder code = new StringBuilder();
        for (String element : elements) {
            if (!Utils.isNotEmpty(element)) continue;
            code.append(code.length() == 0 ? "" : CODE_SEPARATOR);
            code.append(element);
        }
        return code.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getTypeMismatchCode() {
        return this.typeMismatchCode;
    }

    public void setTypeMismatchCode(String typeMismatchCode) {
        this.typeMismatchCode = typeMismatchCode;
    }
}

