/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.validation;

import com.github.mygreen.supercsv.builder.ColumnMapping;
import com.github.mygreen.supercsv.util.ArgUtils;
import com.github.mygreen.supercsv.validation.CsvBindingErrors;
import com.github.mygreen.supercsv.validation.CsvFieldError;
import com.github.mygreen.supercsv.validation.CsvFieldValidator;
import com.github.mygreen.supercsv.validation.ValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CsvField<T> {
    private final String name;
    private final T value;
    private final ColumnMapping columnMapping;
    private final ValidationContext<?> validationContext;
    private final List<CsvFieldValidator<T>> validators = new ArrayList<CsvFieldValidator<T>>();

    public <R> CsvField(ValidationContext<R> validationContext, R record, String fieldName) {
        Objects.requireNonNull(validationContext);
        Objects.requireNonNull(record);
        ArgUtils.notEmpty(fieldName, "fieldName");
        this.columnMapping = validationContext.getBeanMapping().getColumnMapping(fieldName).orElseThrow(() -> new IllegalArgumentException(String.format("not found field '%s' in record '%s'", fieldName, record.getClass().getName())));
        this.validationContext = validationContext;
        this.name = fieldName;
        this.value = this.columnMapping.getField().getValue(record);
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.columnMapping.getField().getType();
    }

    public String getLabel() {
        return this.columnMapping.getLabel();
    }

    public int getColumnNumber() {
        return this.columnMapping.getNumber();
    }

    public boolean hasError(CsvBindingErrors bindingErrors) {
        Objects.requireNonNull(bindingErrors);
        return bindingErrors.hasFieldErrors(this.name);
    }

    public boolean hasNotError(CsvBindingErrors bindingErrors) {
        return !this.hasError(bindingErrors);
    }

    public boolean isEmpty() {
        if (this.value == null) {
            return true;
        }
        if (this.value instanceof String) {
            return ((String)this.value).isEmpty();
        }
        return false;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public CsvField<T> add(CsvFieldValidator<T> validator) {
        Objects.requireNonNull(validator);
        this.validators.add(validator);
        return this;
    }

    public CsvField<T> validate(CsvBindingErrors bindingErrors) {
        Objects.requireNonNull(bindingErrors);
        for (CsvFieldValidator<T> validator : this.getValidators()) {
            if (this.hasError(bindingErrors)) {
                return this;
            }
            validator.validate(bindingErrors, this);
        }
        return this;
    }

    public List<CsvFieldError> getFieldErrors(CsvBindingErrors bindingErrors) {
        Objects.requireNonNull(bindingErrors);
        return bindingErrors.getFieldErrors(this.getName());
    }

    public T getValue() {
        return this.value;
    }

    public ColumnMapping getColumnMapping() {
        return this.columnMapping;
    }

    public ValidationContext<?> getValidationContext() {
        return this.validationContext;
    }

    public List<CsvFieldValidator<T>> getValidators() {
        return this.validators;
    }
}

