/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.validation;

import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.builder.ColumnMapping;
import com.github.mygreen.supercsv.exception.SuperCsvBindingException;
import com.github.mygreen.supercsv.exception.SuperCsvNoMatchColumnSizeException;
import com.github.mygreen.supercsv.exception.SuperCsvNoMatchHeaderException;
import com.github.mygreen.supercsv.exception.SuperCsvRowException;
import com.github.mygreen.supercsv.exception.SuperCsvValidationException;
import com.github.mygreen.supercsv.localization.MessageInterpolator;
import com.github.mygreen.supercsv.localization.MessageResolver;
import com.github.mygreen.supercsv.localization.ResourceBundleMessageResolver;
import com.github.mygreen.supercsv.util.Utils;
import com.github.mygreen.supercsv.validation.CsvError;
import com.github.mygreen.supercsv.validation.CsvFieldError;
import com.github.mygreen.supercsv.validation.MessageCodeGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.util.CsvContext;

public class CsvExceptionConverter {
    private MessageResolver messageResolver = new ResourceBundleMessageResolver();
    private MessageInterpolator messageInterpolator = new MessageInterpolator();
    private MessageCodeGenerator codeGenerator = new MessageCodeGenerator();

    public List<String> convertAndFormat(SuperCsvException exception, BeanMapping<?> beanMapping) {
        return this.convert(exception, beanMapping).stream().map(error -> error.format(this.messageResolver, this.messageInterpolator)).collect(Collectors.toList());
    }

    public List<CsvError> convert(SuperCsvException exception, BeanMapping<?> beanMapping) {
        Objects.requireNonNull(beanMapping, "beanMapping should not be null.");
        Objects.requireNonNull(exception, "exception should not be null.");
        ArrayList<CsvError> errors = new ArrayList<CsvError>();
        if (exception instanceof SuperCsvBindingException) {
            errors.addAll(this.convert((SuperCsvBindingException)exception, beanMapping));
        }
        if (exception instanceof SuperCsvRowException) {
            errors.addAll(this.convert((SuperCsvRowException)exception, beanMapping));
        } else if (exception instanceof SuperCsvValidationException) {
            errors.addAll(this.convert((SuperCsvValidationException)((Object)exception), beanMapping));
        } else if (exception instanceof SuperCsvCellProcessorException) {
            errors.addAll(this.convert((SuperCsvCellProcessorException)((Object)exception), beanMapping));
        } else if (exception instanceof SuperCsvNoMatchColumnSizeException) {
            errors.addAll(this.convert((SuperCsvNoMatchColumnSizeException)exception, beanMapping));
        } else if (exception instanceof SuperCsvNoMatchHeaderException) {
            errors.addAll(this.convert((SuperCsvNoMatchHeaderException)exception, beanMapping));
        } else {
            errors.addAll(this.convertDefault(exception, beanMapping));
        }
        return errors;
    }

    private List<CsvError> convert(SuperCsvBindingException exception, BeanMapping<?> beanMapping) {
        return exception.getBindingErrors().getAllErrors();
    }

    private List<CsvError> convert(SuperCsvRowException exception, BeanMapping<?> beanMapping) {
        return exception.getColumnErrors().stream().flatMap(e -> this.convert((SuperCsvException)((Object)e), beanMapping).stream()).collect(Collectors.toList());
    }

    private List<CsvFieldError> convert(SuperCsvValidationException exception, BeanMapping<?> beanMapping) {
        CsvContext context = exception.getCsvContext();
        int columnNumber = context.getColumnNumber();
        ColumnMapping columnMapping = beanMapping.getColumnMapping(columnNumber).orElseThrow(() -> new IllegalStateException(String.format("not found column definition with umber=%d.", columnNumber)));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("lineNumber", context.getLineNumber());
        variables.put("rowNumber", context.getRowNumber());
        variables.put("columnNumber", context.getColumnNumber());
        variables.put("label", columnMapping.getLabel());
        variables.put("validatedValue", exception.getRejectedValue());
        variables.putAll(exception.getMessageVariables());
        String defaultMessage = exception.getValidationMessage();
        String errorCode = exception.getProcessor().getClass().getSimpleName();
        String objectName = beanMapping.getType().getSimpleName();
        String fieldName = columnMapping.getName();
        String[] typeMismatchCodes = new String[]{};
        if (exception.isParedError()) {
            typeMismatchCodes = this.codeGenerator.generateTypeMismatchCodes(objectName, columnMapping.getName(), columnMapping.getField().getType());
        }
        String[] errorCodes = this.codeGenerator.generateCodes(errorCode, objectName, columnMapping.getName(), columnMapping.getField().getType());
        errorCodes = Utils.concat(typeMismatchCodes, errorCodes);
        CsvFieldError fieldError = new CsvFieldError.Builder(objectName, fieldName, errorCodes).processingFailure(true).variables(variables).defaultMessage(defaultMessage).build();
        return Arrays.asList(fieldError);
    }

    private List<CsvFieldError> convert(SuperCsvCellProcessorException exception, BeanMapping<?> beanMapping) {
        CsvContext context = exception.getCsvContext();
        int columnNumber = context.getColumnNumber();
        Object rejectedValue = context.getRowSource().get(columnNumber - 1);
        ColumnMapping columnMapping = beanMapping.getColumnMapping(columnNumber).orElseThrow(() -> new IllegalStateException(String.format("not found column definition with number=%d.", columnNumber)));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("lineNumber", context.getLineNumber());
        variables.put("rowNumber", context.getRowNumber());
        variables.put("columnNumber", context.getColumnNumber());
        variables.put("label", columnMapping.getLabel());
        variables.put("validatedValue", rejectedValue);
        String defaultMessage = exception.getMessage();
        String errorCode = exception.getProcessor().getClass().getSimpleName();
        String objectName = beanMapping.getType().getSimpleName();
        String fieldName = columnMapping.getName();
        String[] errorCodes = this.codeGenerator.generateCodes(errorCode, objectName, columnMapping.getName(), columnMapping.getField().getType());
        CsvFieldError fieldError = new CsvFieldError.Builder(objectName, fieldName, errorCodes).processingFailure(true).variables(variables).defaultMessage(defaultMessage).build();
        return Arrays.asList(fieldError);
    }

    private List<CsvError> convert(SuperCsvNoMatchColumnSizeException exception, BeanMapping<?> beanMapping) {
        CsvContext context = exception.getCsvContext();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("lineNumber", context.getLineNumber());
        variables.put("rowNumber", context.getRowNumber());
        variables.put("expectedSize", exception.getEpxpectedColumnSize());
        variables.put("actualSize", exception.getActualColumnSize());
        String defaultMessage = exception.getMessage();
        String errorCode = "csvError.noMatchColumnSize";
        String objectName = beanMapping.getType().getSimpleName();
        String[] errorCodes = this.codeGenerator.generateCodes("csvError.noMatchColumnSize", objectName);
        CsvError error = new CsvError.Builder(objectName, errorCodes).variables(variables).defaultMessage(defaultMessage).build();
        return Arrays.asList(error);
    }

    private List<CsvError> convert(SuperCsvNoMatchHeaderException exception, BeanMapping<?> beanMapping) {
        CsvContext context = exception.getCsvContext();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("lineNumber", context.getLineNumber());
        variables.put("rowNumber", context.getRowNumber());
        variables.put("expectedHeaders", exception.getExpectedHeaders());
        variables.put("actualHeaders", exception.getActualHeaders());
        variables.put("joinedExpectedHeaders", String.join((CharSequence)", ", exception.getExpectedHeaders()));
        variables.put("joinedActualHeaders", String.join((CharSequence)", ", exception.getActualHeaders()));
        String defaultMessage = exception.getMessage();
        String errorCode = "csvError.noMatchHeader";
        String objectName = beanMapping.getType().getSimpleName();
        String[] errorCodes = this.codeGenerator.generateCodes("csvError.noMatchHeader", objectName);
        CsvError error = new CsvError.Builder(objectName, errorCodes).variables(variables).defaultMessage(defaultMessage).build();
        return Arrays.asList(error);
    }

    private List<CsvError> convertDefault(SuperCsvException exception, BeanMapping<?> beanMapping) {
        CsvContext context = exception.getCsvContext();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("lineNumber", context.getLineNumber());
        variables.put("rowNumber", context.getRowNumber());
        variables.put("columnNumber", context.getColumnNumber());
        String defaultMessage = exception.getMessage();
        String errorCode = "csvError";
        String objectName = beanMapping.getType().getSimpleName();
        String[] errorCodes = this.codeGenerator.generateCodes("csvError", objectName);
        CsvError error = new CsvError.Builder(objectName, errorCodes).variables(variables).defaultMessage(defaultMessage).build();
        return Arrays.asList(error);
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public MessageCodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public void setCodeGenerator(MessageCodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }
}

