/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.validation;

import com.github.mygreen.supercsv.util.ArgUtils;
import com.github.mygreen.supercsv.util.Utils;
import com.github.mygreen.supercsv.validation.CsvError;
import com.github.mygreen.supercsv.validation.CsvFieldError;
import com.github.mygreen.supercsv.validation.MessageCodeGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CsvBindingErrors
implements Serializable {
    private static final long serialVersionUID = -9014484172903397334L;
    public static final String PATH_SEPARATOR = ".";
    private final String objectName;
    private final List<CsvError> errors = new ArrayList<CsvError>();
    private MessageCodeGenerator messageCodeGenerator = new MessageCodeGenerator();

    public CsvBindingErrors(String objectName) {
        Objects.requireNonNull(objectName);
        this.objectName = objectName;
    }

    public CsvBindingErrors(Class<?> clazz) {
        this(clazz.getSimpleName());
    }

    public String getObjectName() {
        return this.objectName;
    }

    public List<CsvError> getAllErrors() {
        return new ArrayList<CsvError>(this.errors);
    }

    public void addError(CsvError error) {
        this.errors.add(error);
    }

    public void addAllErrors(Collection<CsvError> errors) {
        this.errors.addAll(errors);
    }

    public void clearAllErrors() {
        this.errors.clear();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<CsvError> getGlobalErrors() {
        ArrayList<CsvError> list = new ArrayList<CsvError>();
        for (CsvError item : this.errors) {
            if (item instanceof CsvFieldError) continue;
            list.add(item);
        }
        return list;
    }

    public CsvError getFirstGlobalError() {
        for (CsvError item : this.errors) {
            if (item instanceof CsvFieldError) continue;
            return item;
        }
        return null;
    }

    public boolean hasGlobalErrors() {
        return !this.getGlobalErrors().isEmpty();
    }

    public int getGlobalErrorCount() {
        return this.getGlobalErrors().size();
    }

    public List<CsvFieldError> getFieldErrors() {
        ArrayList<CsvFieldError> list = new ArrayList<CsvFieldError>();
        for (CsvError item : this.errors) {
            if (!(item instanceof CsvFieldError)) continue;
            list.add((CsvFieldError)item);
        }
        return list;
    }

    public CsvFieldError getFirstFieldError() {
        for (CsvError item : this.errors) {
            if (!(item instanceof CsvFieldError)) continue;
            return (CsvFieldError)item;
        }
        return null;
    }

    public boolean hasFieldErrors() {
        return !this.getFieldErrors().isEmpty();
    }

    public int getFieldErrorCount() {
        return this.getFieldErrors().size();
    }

    public List<CsvFieldError> getFieldErrors(String path) {
        ArgUtils.notEmpty(path, "path");
        ArrayList<CsvFieldError> list = new ArrayList<CsvFieldError>();
        for (CsvError item : this.errors) {
            if (!(item instanceof CsvFieldError) || !this.isMatchingFieldError(path, (CsvFieldError)item)) continue;
            list.add((CsvFieldError)item);
        }
        return list;
    }

    public CsvFieldError getFirstFieldError(String path) {
        ArgUtils.notEmpty(path, "path");
        for (CsvError item : this.errors) {
            if (!(item instanceof CsvFieldError) || !this.isMatchingFieldError(path, (CsvFieldError)item)) continue;
            return (CsvFieldError)item;
        }
        return null;
    }

    public boolean hasFieldErrors(String path) {
        return !this.getFieldErrors(path).isEmpty();
    }

    public int getFieldErrorCount(String path) {
        return this.getFieldErrors(path).size();
    }

    private boolean isMatchingFieldError(String path, CsvFieldError fieldError) {
        if (fieldError.getField().equals(path)) {
            return true;
        }
        if (path.endsWith("*")) {
            String subPath = path.substring(0, path.length() - 1);
            return fieldError.getField().startsWith(subPath);
        }
        return false;
    }

    public void reject(String errorCode) {
        this.reject(errorCode, Collections.emptyMap(), null);
    }

    public void reject(String errorCode, String defaultMessage) {
        this.reject(errorCode, Collections.emptyMap(), defaultMessage);
    }

    public void reject(String errorCode, Map<String, Object> messageVariables) {
        this.reject(errorCode, messageVariables, null);
    }

    public void reject(String errorCode, Map<String, Object> messageVariables, String defaultMessage) {
        this.reject(new String[]{errorCode}, messageVariables, defaultMessage);
    }

    public void reject(String[] errorCodes, Map<String, Object> messageVariables, String defaultMessage) {
        String[] codes = new String[]{};
        for (String errorCode : errorCodes) {
            codes = Utils.concat(codes, this.messageCodeGenerator.generateCodes(errorCode, this.getObjectName()));
        }
        this.addError(new CsvError(this.getObjectName(), codes, messageVariables, defaultMessage));
    }

    public void rejectValue(String field, String errorCode) {
        this.rejectValue(field, null, errorCode, Collections.emptyMap(), null);
    }

    public void rejectValue(String field, String errorCode, String defaultMessage) {
        this.rejectValue(field, null, errorCode, Collections.emptyMap(), defaultMessage);
    }

    public void rejectValue(String field, String errorCode, Map<String, Object> messageVariables, String defaultMessage) {
        this.rejectValue(field, null, errorCode, Collections.emptyMap(), defaultMessage);
    }

    public void rejectValue(String field, Class<?> fieldType, String errorCode, Map<String, Object> messageVariables) {
        this.rejectValue(field, fieldType, errorCode, messageVariables, null);
    }

    public void rejectValue(String field, Class<?> fieldType, String errorCode, Map<String, Object> messageVariables, String defaultMessage) {
        this.rejectValue(field, fieldType, new String[]{errorCode}, messageVariables, defaultMessage);
    }

    public void rejectValue(String field, Class<?> fieldType, String[] errorCodes, Map<String, Object> messageVariables, String defaultMessage) {
        String[] codes = new String[]{};
        for (String errorCode : errorCodes) {
            codes = Utils.concat(codes, this.messageCodeGenerator.generateCodes(errorCode, this.getObjectName(), field, fieldType));
        }
        this.addError(new CsvFieldError(this.getObjectName(), field, false, codes, messageVariables, defaultMessage));
    }

    public MessageCodeGenerator getMessageCodeGenerator() {
        return this.messageCodeGenerator;
    }

    public void setMessageCodeGenerator(MessageCodeGenerator messageCodeGenerator) {
        this.messageCodeGenerator = messageCodeGenerator;
    }
}

