/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.util;

import java.util.Collection;
import java.util.Map;

public class ArgUtils {
    public static void notNull(Object arg, String name) {
        if (arg == null) {
            throw new NullPointerException(String.format("%s should not be null.", name));
        }
    }

    public static void notEmpty(String arg, String name) {
        if (arg == null) {
            throw new NullPointerException(String.format("%s should not be null.", name));
        }
        if (arg.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s should not be empty.", name));
        }
    }

    public static void notEmpty(Object[] arg, String name) {
        if (arg == null) {
            throw new NullPointerException(String.format("%s should not be null.", name));
        }
        if (arg.length == 0) {
            throw new IllegalArgumentException(String.format("%s should has length ararys.", name));
        }
    }

    public static void notEmpty(Collection<?> arg, String name) {
        if (arg == null) {
            throw new NullPointerException(String.format("%s should not be null.", name));
        }
        if (arg.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s should not be empty.", name));
        }
    }

    public static void notEmpty(Map<?, ?> arg, String name) {
        if (arg == null) {
            throw new NullPointerException(String.format("%s should not be null.", name));
        }
        if (arg.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s should not be empty.", name));
        }
    }

    public static <T extends Comparable> void notMin(T arg, T min, String name) {
        if (arg == null) {
            throw new NullPointerException(String.format("%s should not be null.", name));
        }
        if (arg.compareTo(min) < 0) {
            throw new IllegalArgumentException(String.format("%s cannot be smaller than %s", name, min.toString()));
        }
    }

    public static <T extends Comparable> void notMax(T arg, T max, String name) {
        if (arg == null) {
            throw new NullPointerException(String.format("%s should not be null.", name));
        }
        if (arg.compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("%s cannot be greater than %s", name, max.toString()));
        }
    }
}

