/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.localization;

import com.github.mygreen.supercsv.localization.EncodingControl;
import com.github.mygreen.supercsv.localization.MessageResolver;
import com.github.mygreen.supercsv.util.ArgUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;

public class ResourceBundleMessageResolver
implements MessageResolver {
    public static final String DEFAULT_MESSAGE = "com.github.mygreen.supercsv.localization.SuperCsvMessages";
    private final Map<ResourceBundle, List<String>> messageBundleKeys = new HashMap<ResourceBundle, List<String>>(8);
    private final LinkedList<ResourceBundle> messageBundles = new LinkedList();

    public ResourceBundleMessageResolver(String baseName, boolean appendUserResource) {
        int index;
        ArgUtils.notEmpty(baseName, "baseName");
        this.addResourceBundle(ResourceBundle.getBundle(baseName, new EncodingControl("UTF-8")));
        if (appendUserResource && (index = baseName.lastIndexOf(".")) > 0) {
            String userName = baseName.substring(index + 1);
            try {
                this.addResourceBundle(ResourceBundle.getBundle(userName, new EncodingControl("UTF-8")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ResourceBundleMessageResolver() {
        this(DEFAULT_MESSAGE, true);
    }

    public ResourceBundleMessageResolver(ResourceBundle resourceBundle) {
        this();
        Objects.requireNonNull(resourceBundle, "resourceBundle should no be null");
        this.addResourceBundle(resourceBundle);
    }

    @Override
    public Optional<String> getMessage(String code) {
        for (ResourceBundle bundle : this.messageBundles) {
            List<String> keys = this.messageBundleKeys.get(bundle);
            if (!keys.contains(code)) continue;
            try {
                return Optional.of(bundle.getString(code));
            }
            catch (MissingResourceException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public final boolean addResourceBundle(ResourceBundle resourceBundle) {
        Objects.requireNonNull(resourceBundle, "resourceBundle should not be null.");
        if (this.messageBundles.contains(resourceBundle)) {
            return false;
        }
        this.messageBundles.addFirst(resourceBundle);
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration<String> keysEnum = resourceBundle.getKeys();
        while (keysEnum.hasMoreElements()) {
            keys.add(keysEnum.nextElement());
        }
        this.messageBundleKeys.put(resourceBundle, keys);
        return true;
    }

    public boolean removeResourceBundle(ResourceBundle resourceBundle) {
        Objects.requireNonNull(resourceBundle, "resourceBundle should not be null.");
        if (!this.messageBundles.contains(resourceBundle)) {
            return false;
        }
        this.messageBundles.remove(resourceBundle);
        return true;
    }
}

