/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.localization;

import com.github.mygreen.supercsv.expression.CustomFunctions;
import com.github.mygreen.supercsv.expression.ExpressionEvaluationException;
import com.github.mygreen.supercsv.expression.ExpressionLanguage;
import com.github.mygreen.supercsv.expression.ExpressionLanguageJEXLImpl;
import com.github.mygreen.supercsv.localization.MessageParseException;
import com.github.mygreen.supercsv.localization.MessageResolver;
import com.github.mygreen.supercsv.util.StackUtils;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageInterpolator {
    private static final Logger logger = LoggerFactory.getLogger(MessageInterpolator.class);
    private ExpressionLanguage expressionLanguage;

    public MessageInterpolator() {
        ExpressionLanguageJEXLImpl el = new ExpressionLanguageJEXLImpl();
        HashMap<String, Class<CustomFunctions>> funcs = new HashMap<String, Class<CustomFunctions>>();
        funcs.put("f", CustomFunctions.class);
        el.getJexlEngine().setFunctions(funcs);
        this.setExpressionLanguage(el);
    }

    public MessageInterpolator(ExpressionLanguage expressionLanguage) {
        Objects.requireNonNull(expressionLanguage, "expressionLanguage should not be null.");
        this.expressionLanguage = expressionLanguage;
    }

    public String interpolate(String message, Map<String, ?> vars) {
        return this.interpolate(message, vars, false);
    }

    public String interpolate(String message, Map<String, ?> vars, boolean recursive) {
        return this.parse(message, vars, recursive, null);
    }

    public String interpolate(String message, Map<String, ?> vars, boolean recursive, MessageResolver messageResolver) {
        return this.parse(message, vars, recursive, messageResolver);
    }

    protected String parse(String message, Map<String, ?> vars, boolean recursive, MessageResolver messageResolver) {
        StringBuilder sb = new StringBuilder(message.length());
        LinkedList<String> stack = new LinkedList<String>();
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            char c = message.charAt(i);
            if (StackUtils.equalsTopElement(stack, "\\")) {
                String escapedChar = StackUtils.popup(stack) + c;
                if (!stack.isEmpty()) {
                    stack.push(escapedChar);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                stack.push(String.valueOf(c));
                continue;
            }
            if (c == '$') {
                stack.push(String.valueOf(c));
                continue;
            }
            if (c == '{') {
                if (!stack.isEmpty() && !StackUtils.equalsAnyBottomElement(stack, new String[]{"$", "{"})) {
                    throw new MessageParseException(message, "expression not start with '{' or '$'");
                }
                stack.push(String.valueOf(c));
                continue;
            }
            if (c == '}') {
                if (StackUtils.equalsAnyBottomElement(stack, new String[]{"{", "$"})) {
                    String expression = StackUtils.popupAndConcat(stack) + c;
                    expression = this.removeEscapeChar(expression, '\\');
                    String result = this.evaluate(expression, vars, recursive, messageResolver);
                    sb.append(result);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (stack.isEmpty()) {
                sb.append(c);
                continue;
            }
            stack.push(String.valueOf(c));
        }
        if (!stack.isEmpty()) {
            String val = StackUtils.popupAndConcat(stack);
            val = this.removeEscapeChar(val, '\\');
            sb.append(val);
        }
        return sb.toString();
    }

    private String evaluate(String expression, Map<String, ?> values, boolean recursive, MessageResolver messageResolver) {
        if (expression.startsWith("{")) {
            String varName = expression.substring(1, expression.length() - 1);
            if (values.containsKey(varName)) {
                String eval;
                Object value = values.get(varName);
                String string = eval = value == null ? "" : value.toString();
                if (!eval.isEmpty() && recursive) {
                    return this.parse(eval, values, recursive, messageResolver);
                }
                return eval;
            }
            if (messageResolver != null) {
                Optional<String> eval = messageResolver.getMessage(varName);
                if (!eval.isPresent()) {
                    return String.format("{%s}", varName);
                }
                if (recursive) {
                    return this.parse(eval.get(), values, recursive, messageResolver);
                }
                return eval.get();
            }
            return expression.toString();
        }
        if (expression.startsWith("${")) {
            String expr = expression.substring(2, expression.length() - 1);
            String eval = this.evaluateExpression(expr, values);
            if (recursive) {
                return this.parse(eval, values, recursive, messageResolver);
            }
            return eval;
        }
        throw new MessageParseException(expression, "not support expression.");
    }

    protected String evaluateExpression(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
        context.putAll(values);
        context.computeIfAbsent("formatter", key -> new Formatter());
        String value = this.expressionLanguage.evaluate(expression, context).toString();
        if (logger.isTraceEnabled()) {
            logger.trace("evaluate expression language: expression='{}' ===> value='{}'", (Object)expression, (Object)value);
        }
        return value;
    }

    private String removeEscapeChar(String str, char escapeChar) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String escapeStr = String.valueOf(escapeChar);
        StringBuilder sb = new StringBuilder();
        LinkedList<String> stack = new LinkedList<String>();
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (StackUtils.equalsTopElement(stack, escapeStr)) {
                StackUtils.popup(stack);
                sb.append(c);
                continue;
            }
            if (c == escapeChar) {
                stack.push(String.valueOf(c));
                continue;
            }
            sb.append(c);
        }
        if (!stack.isEmpty()) {
            sb.append(StackUtils.popupAndConcat(stack));
        }
        return sb.toString();
    }

    public ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }
}

