/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.io;

import com.github.mygreen.supercsv.annotation.CsvPartial;
import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.builder.BeanMappingFactoryHelper;
import com.github.mygreen.supercsv.builder.ColumnMapping;
import com.github.mygreen.supercsv.builder.HeaderMapper;
import com.github.mygreen.supercsv.builder.LazyBeanMappingFactory;
import com.github.mygreen.supercsv.exception.SuperCsvBindingException;
import com.github.mygreen.supercsv.io.AbstractCsvAnnotationBeanWriter;
import com.github.mygreen.supercsv.io.BeanMappingCache;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.supercsv.prefs.CsvPreference;

public class LazyCsvAnnotationBeanWriter<T>
extends AbstractCsvAnnotationBeanWriter<T> {
    private final BeanMapping<T> beanMapping;
    private boolean initialized = false;

    public LazyCsvAnnotationBeanWriter(Class<T> beanType, Writer writer, CsvPreference preference, Class<?> ... groups) {
        super(writer, preference);
        Objects.requireNonNull(beanType, "beanType should not be null.");
        LazyBeanMappingFactory factory = new LazyBeanMappingFactory();
        this.beanMapping = factory.create(beanType, groups);
        this.validators.addAll(this.beanMapping.getValidators());
    }

    public LazyCsvAnnotationBeanWriter(BeanMapping<T> beanMapping, Writer writer, CsvPreference preference, Class<?> ... groups) {
        super(writer, preference);
        Objects.requireNonNull(beanMapping, "beanMapping should not be null.");
        this.beanMapping = beanMapping;
        this.validators.addAll(beanMapping.getValidators());
    }

    private IllegalStateException newNotInitialzedException() {
        return new IllegalStateException(MessageBuilder.create("noinit.onLazyWrite").format());
    }

    public void init() {
        this.init(new String[0]);
    }

    public void init(String ... headers) {
        this.setupMappingColumns(headers);
        this.beanMappingCache = BeanMappingCache.create(this.beanMapping);
        this.initialized = true;
    }

    private void setupMappingColumns(String[] headers) {
        List<ColumnMapping> columnMappingList = this.beanMapping.getColumns();
        HeaderMapper headerMapper = this.beanMapping.getHeaderMapper();
        int headerSize = headers.length;
        for (int i = 0; i < headerSize; ++i) {
            String header = headers[i];
            List<ColumnMapping> undeterminedColumnList = columnMappingList.stream().filter(col -> !col.isDeterminedNumber()).filter(col -> headerMapper.toMap((ColumnMapping)col, this.beanMapping.getConfiguration(), this.beanMapping.getGroups()).equals(header)).collect(Collectors.toList());
            int columnNumber = i + 1;
            undeterminedColumnList.forEach(col -> col.setNumber(columnNumber));
        }
        columnMappingList.sort(null);
        Optional<CsvPartial> partialAnno = Optional.ofNullable(this.beanMapping.getType().getAnnotation(CsvPartial.class));
        List undeterminedColumnList = columnMappingList.stream().filter(col -> !col.isDeterminedNumber()).collect(Collectors.toList());
        if (!undeterminedColumnList.isEmpty()) {
            Set determinedNumbers = columnMappingList.stream().filter(col -> col.isDeterminedNumber()).map(col -> col.getNumber()).collect(Collectors.toSet());
            partialAnno.ifPresent(anno -> Arrays.stream(anno.headers()).forEach(header -> determinedNumbers.add(header.number())));
            int counter = 1;
            for (ColumnMapping col2 : undeterminedColumnList) {
                while (determinedNumbers.contains(counter)) {
                    ++counter;
                }
                col2.setNumber(counter);
                determinedNumbers.add(counter);
            }
            columnMappingList.sort(null);
        }
        BeanMappingFactoryHelper.validateNonDeterminedColumnNumber(this.beanMapping.getType(), columnMappingList, headers);
        BeanMappingFactoryHelper.validateDuplicatedColumnNumber(this.beanMapping.getType(), columnMappingList);
        BeanMappingFactoryHelper.supplyLackedNumberMappingColumn(this.beanMapping.getType(), columnMappingList, partialAnno, headers);
        this.beanMapping.setColumns(columnMappingList);
    }

    public void writeHeader() throws IOException {
        if (!this.initialized) {
            throw this.newNotInitialzedException();
        }
        super.writeHeader(this.getDefinedHeader());
    }

    public void writeAll(Collection<T> sources) throws IOException {
        this.writeAll(sources, false);
    }

    public void writeAll(Collection<T> sources, boolean continueOnError) throws IOException {
        Objects.requireNonNull(sources, "sources should not be null.");
        if (!this.initialized) {
            this.init();
        }
        if (this.beanMappingCache.getOriginal().isHeader() && this.getLineNumber() == 0) {
            this.writeHeader();
        }
        for (T record : sources) {
            try {
                this.write(record);
            }
            catch (SuperCsvBindingException e) {
                if (continueOnError) continue;
                throw e;
            }
        }
        super.flush();
    }

    @Override
    public void write(T source) throws IOException {
        if (!this.initialized) {
            throw this.newNotInitialzedException();
        }
        super.write(source);
    }

    @Override
    public String[] getDefinedHeader() {
        if (!this.initialized) {
            throw this.newNotInitialzedException();
        }
        return super.getDefinedHeader();
    }

    @Override
    public BeanMapping<T> getBeanMapping() {
        if (!this.initialized) {
            throw this.newNotInitialzedException();
        }
        return super.getBeanMapping();
    }
}

