/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.io;

import com.github.mygreen.supercsv.annotation.CsvPartial;
import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.builder.BeanMappingFactoryHelper;
import com.github.mygreen.supercsv.builder.ColumnMapping;
import com.github.mygreen.supercsv.builder.HeaderMapper;
import com.github.mygreen.supercsv.builder.LazyBeanMappingFactory;
import com.github.mygreen.supercsv.exception.SuperCsvBindingException;
import com.github.mygreen.supercsv.exception.SuperCsvNoMatchColumnSizeException;
import com.github.mygreen.supercsv.exception.SuperCsvNoMatchHeaderException;
import com.github.mygreen.supercsv.io.AbstractCsvAnnotationBeanReader;
import com.github.mygreen.supercsv.io.BeanMappingCache;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.supercsv.io.ITokenizer;
import org.supercsv.prefs.CsvPreference;

public class LazyCsvAnnotationBeanReader<T>
extends AbstractCsvAnnotationBeanReader<T> {
    private final BeanMapping<T> beanMapping;
    private boolean initialized = false;

    public LazyCsvAnnotationBeanReader(Class<T> beanType, Reader reader, CsvPreference preference, Class<?> ... groups) {
        super(reader, preference);
        Objects.requireNonNull(beanType, "beanType should not be null.");
        LazyBeanMappingFactory factory = new LazyBeanMappingFactory();
        this.beanMapping = factory.create(beanType, groups);
        this.validators.addAll(this.beanMapping.getValidators());
    }

    public LazyCsvAnnotationBeanReader(BeanMapping<T> beanMapping, Reader reader, CsvPreference preference, Class<?> ... groups) {
        super(reader, preference);
        Objects.requireNonNull(beanMapping, "beanMapping should not be null.");
        this.beanMapping = beanMapping;
        this.validators.addAll(beanMapping.getValidators());
    }

    public LazyCsvAnnotationBeanReader(Class<T> beanType, ITokenizer tokenizer, CsvPreference preference, Class<?> ... groups) {
        super(tokenizer, preference);
        Objects.requireNonNull(beanType, "beanType should not be null.");
        LazyBeanMappingFactory factory = new LazyBeanMappingFactory();
        this.beanMapping = factory.create(beanType, groups);
        this.validators.addAll(this.beanMapping.getValidators());
    }

    public LazyCsvAnnotationBeanReader(BeanMapping<T> beanMapping, ITokenizer tokenizer, CsvPreference preference, Class<?> ... groups) {
        super(tokenizer, preference);
        Objects.requireNonNull(beanMapping, "beanMapping should not be null.");
        this.beanMapping = beanMapping;
        this.validators.addAll(beanMapping.getValidators());
    }

    public String[] init() throws IOException {
        String[] headers = this.getHeader(true);
        this.init(headers);
        return headers;
    }

    public void init(String ... headers) {
        this.setupMappingColumns(headers);
        this.beanMappingCache = BeanMappingCache.create(this.beanMapping);
        if (this.beanMappingCache.getOriginal().isValidateHeader()) {
            try {
                this.validateHeader(headers, this.beanMapping.getHeader());
            }
            catch (SuperCsvNoMatchColumnSizeException | SuperCsvNoMatchHeaderException e) {
                this.errorMessages.addAll(this.exceptionConverter.convertAndFormat(e, this.beanMappingCache.getOriginal()));
                throw e;
            }
        }
        this.initialized = true;
    }

    private IllegalStateException newNotInitialzedException() {
        return new IllegalStateException(MessageBuilder.create("noinit.onLazyRead").format());
    }

    public List<T> readAll() throws IOException {
        return this.readAll(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<T> readAll(boolean continueOnError) throws IOException {
        block7: {
            if (!this.initialized) {
                if (!this.beanMapping.isHeader()) throw this.newNotInitialzedException();
                try {
                    this.init();
                }
                catch (SuperCsvNoMatchColumnSizeException | SuperCsvNoMatchHeaderException e) {
                    if (continueOnError) break block7;
                    throw e;
                }
            }
        }
        ArrayList<T> list = new ArrayList<T>();
        while (true) {
            try {
                T record;
                while ((record = this.read()) != null) {
                    list.add(record);
                }
                return list;
            }
            catch (SuperCsvBindingException | SuperCsvNoMatchColumnSizeException e) {
                if (continueOnError) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public T read() throws IOException {
        if (!this.initialized) {
            throw this.newNotInitialzedException();
        }
        return super.read();
    }

    private void setupMappingColumns(String[] headers) {
        List<ColumnMapping> columnMappingList = this.beanMapping.getColumns();
        HeaderMapper headerMapper = this.beanMapping.getHeaderMapper();
        int headerSize = headers.length;
        for (int i = 0; i < headerSize; ++i) {
            String header = headers[i];
            List<ColumnMapping> undeterminedColumnList = columnMappingList.stream().filter(col -> col.getNumber() <= 0).filter(col -> headerMapper.toMap((ColumnMapping)col, this.beanMapping.getConfiguration(), this.beanMapping.getGroups()).equals(header)).collect(Collectors.toList());
            int columnNumber = i + 1;
            undeterminedColumnList.forEach(col -> col.setNumber(columnNumber));
        }
        columnMappingList.sort(null);
        BeanMappingFactoryHelper.validateNonDeterminedColumnNumber(this.beanMapping.getType(), columnMappingList, headers);
        BeanMappingFactoryHelper.validateDuplicatedColumnNumber(this.beanMapping.getType(), columnMappingList);
        Optional<CsvPartial> partialAnno = Optional.ofNullable(this.beanMapping.getType().getAnnotation(CsvPartial.class));
        BeanMappingFactoryHelper.supplyLackedNumberMappingColumn(this.beanMapping.getType(), columnMappingList, partialAnno, headers);
        this.beanMapping.setColumns(columnMappingList);
    }

    @Override
    public String[] getDefinedHeader() {
        if (!this.initialized) {
            throw this.newNotInitialzedException();
        }
        return super.getDefinedHeader();
    }

    @Override
    public BeanMapping<T> getBeanMapping() {
        if (!this.initialized) {
            throw this.newNotInitialzedException();
        }
        return super.getBeanMapping();
    }
}

