/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.exception;

import com.github.mygreen.supercsv.util.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class SuperCsvValidationException
extends SuperCsvCellProcessorException
implements Cloneable {
    private static final long serialVersionUID = 3448638872019192862L;
    private boolean parsedError;
    private Object rejectedValue;
    private String validationMessage;
    private Map<String, Object> messageVariables = new HashMap<String, Object>();

    public SuperCsvValidationException(String msg, CsvContext context, CellProcessor processor) {
        super(msg, context, processor);
    }

    public SuperCsvValidationException(String msg, CsvContext context, CellProcessor processor, Throwable t) {
        super(msg, context, processor, t);
    }

    public Object getRejectedValue() {
        return this.rejectedValue;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public Map<String, Object> getMessageVariables() {
        return this.messageVariables;
    }

    public boolean isParedError() {
        return this.parsedError;
    }

    public SuperCsvValidationException clone() {
        return new Builder(new CsvContext(this.getCsvContext()), this.getProcessor()).message(this.getMessage()).exception(this.getCause()).rejectedValue(this.rejectedValue).validationMessage(this.validationMessage).messageVariables(this.messageVariables).parsedError(this.parsedError).build();
    }

    public static final class Builder {
        private final CsvContext context;
        private final CellProcessor processor;
        private String message;
        private Throwable exception;
        private Object rejectedValue;
        private String validationMessage;
        private Map<String, Object> messageVariables = new HashMap<String, Object>();
        private boolean parsedError;

        public Builder(CsvContext context, CellProcessor processor) {
            this.context = context;
            this.processor = processor;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder messageFormat(String format, Object ... args) {
            return this.message(String.format(format, args));
        }

        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public Builder rejectedValue(Object rejectedValue) {
            this.rejectedValue = rejectedValue;
            return this;
        }

        public Builder validationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
            return this;
        }

        public Builder validationMessageIfPresent(Optional<String> validationMessage) {
            validationMessage.ifPresent(m -> this.validationMessage((String)m));
            return this;
        }

        public Builder messageVariables(String key, Object value) {
            this.messageVariables.put(key, value);
            return this;
        }

        public Builder messageVariablesIfPresent(String key, Optional<?> value) {
            value.ifPresent(v -> this.messageVariables.put(key, v));
            return this;
        }

        public Builder messageVariables(Map<String, Object> arguments) {
            this.messageVariables.putAll(arguments);
            return this;
        }

        public Builder parsedError(boolean parsedError) {
            this.parsedError = parsedError;
            return this;
        }

        public SuperCsvValidationException build() {
            String msg = Optional.ofNullable(this.message).orElseGet(() -> this.processor.getClass().getName() + " error.");
            SuperCsvValidationException error = this.exception == null ? new SuperCsvValidationException(msg, this.context, this.processor) : new SuperCsvValidationException(msg, this.context, this.processor, this.exception);
            error.rejectedValue = this.rejectedValue;
            if (Utils.isNotEmpty(this.validationMessage)) {
                error.validationMessage = this.validationMessage;
            }
            if (this.messageVariables.size() > 0) {
                error.messageVariables = this.messageVariables;
            }
            error.parsedError = this.parsedError;
            return error;
        }
    }
}

