/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.format;

import com.github.mygreen.supercsv.cellprocessor.format.AbstractTextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import com.github.mygreen.supercsv.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.chrono.JapaneseDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TemporalFormatWrapper<T extends TemporalAccessor>
extends AbstractTextFormatter<T> {
    private final DateTimeFormatter formatter;
    private final Class<T> type;
    private final Method parseMethod;
    private String pattern;

    public TemporalFormatWrapper(DateTimeFormatter formatter, Class<T> type) {
        Objects.requireNonNull(formatter);
        Objects.requireNonNull(type);
        this.formatter = formatter;
        this.type = type;
        try {
            this.parseMethod = type.getMethod("parse", CharSequence.class, DateTimeFormatter.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(String.format("Cannot suuport type : %s.", type.getName()));
        }
    }

    @Override
    public T parse(String text) {
        try {
            return (T)((TemporalAccessor)this.parseMethod.invoke(this.type, text, this.formatter));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new TextParseException(text, this.type, "Cannot suuport type.");
        }
        catch (DateTimeParseException e) {
            throw new TextParseException(text, this.type, e);
        }
    }

    @Override
    public String print(T object) {
        if (this.pattern.contains("G") && this.formatter.getLocale().getLanguage().equals("ja") && LocalDate.class.isAssignableFrom(this.type)) {
            JapaneseDate date = JapaneseDate.from((LocalDate)object);
            return this.formatter.format(date);
        }
        return this.formatter.format((TemporalAccessor)object);
    }

    @Override
    public Optional<String> getPattern() {
        if (Utils.isEmpty(this.pattern)) {
            return Optional.empty();
        }
        return Optional.of(this.pattern);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Map<String, Object> getMessageVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        this.getPattern().ifPresent(p -> vars.put("pattern", p));
        return vars;
    }
}

