/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.format;

import com.github.mygreen.supercsv.cellprocessor.format.AbstractTextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NumberFormatWrapper<T extends Number>
extends AbstractTextFormatter<T> {
    private final NumberFormat formatter;
    private final Class<T> type;
    private final boolean lenient;

    public NumberFormatWrapper(NumberFormat formatter, Class<T> type) {
        this(formatter, type, false);
    }

    public NumberFormatWrapper(NumberFormat formatter, Class<T> type, boolean lenient) {
        Objects.requireNonNull(formatter);
        Objects.requireNonNull(type);
        this.formatter = (NumberFormat)formatter.clone();
        this.type = type;
        this.lenient = lenient;
    }

    @Override
    public synchronized String print(Number number) {
        return this.formatter.format(number);
    }

    @Override
    public T parse(String text) {
        return this.parse(this.type, text);
    }

    synchronized <N extends Number> N parse(Class<N> type, String text) {
        Number result;
        if (this.lenient) {
            try {
                result = this.formatter.parse(text);
            }
            catch (ParseException e) {
                throw new TextParseException(text, type, e);
            }
        } else {
            ParsePosition position = new ParsePosition(0);
            result = this.formatter.parse(text, position);
            if (position.getIndex() != text.length()) {
                throw new TextParseException(text, type, String.format("Cannot parse '%s' using fromat %s", text, this.getPattern()));
            }
        }
        try {
            if (result instanceof BigDecimal) {
                return (N)this.convertWithBigDecimal(type, (BigDecimal)result, text);
            }
            return (N)this.convertWithNumber(type, result, text);
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new TextParseException(text, type, e);
        }
    }

    private Number convertWithNumber(Class<? extends Number> type, Number number, String str) {
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
            return number.byteValue();
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
            return number.shortValue();
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return number.intValue();
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return number.longValue();
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(number.floatValue());
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return number.doubleValue();
        }
        if (type.isAssignableFrom(BigInteger.class)) {
            return new BigInteger(str);
        }
        if (type.isAssignableFrom(BigDecimal.class)) {
            return new BigDecimal(str);
        }
        throw new IllegalArgumentException(String.format("not support class type : %s", type.getCanonicalName()));
    }

    private Number convertWithBigDecimal(Class<? extends Number> type, BigDecimal number, String str) {
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.byteValue() : number.byteValueExact();
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.shortValue() : number.shortValueExact();
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.intValue() : number.intValueExact();
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.longValue() : number.longValueExact();
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(number.floatValue());
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return number.doubleValue();
        }
        if (type.isAssignableFrom(BigInteger.class)) {
            return this.lenient ? number.toBigInteger() : number.toBigIntegerExact();
        }
        if (type.isAssignableFrom(BigDecimal.class)) {
            return number;
        }
        throw new IllegalArgumentException(String.format("not support class type : %s", type.getCanonicalName()));
    }

    @Override
    public Optional<String> getPattern() {
        if (this.formatter instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)this.formatter;
            return Optional.of(df.toPattern());
        }
        return Optional.empty();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    @Override
    public Map<String, Object> getMessageVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        this.getPattern().ifPresent(p -> vars.put("pattern", p));
        return vars;
    }
}

