/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.annotation.conversion.CsvWordReplace;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConversionProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.conversion.CharReplacer;
import com.github.mygreen.supercsv.cellprocessor.conversion.ReplacedWordProvider;
import com.github.mygreen.supercsv.cellprocessor.conversion.WordReplace;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;

public class WordReplaceFactory
implements ConversionProcessorFactory<CsvWordReplace> {
    @Override
    public Optional<CellProcessor> create(CsvWordReplace anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        String[] replacements;
        CharReplacer replacer = new CharReplacer();
        String[] words = anno.words();
        if (words.length != (replacements = anno.replacements()).length) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.CsvWordReplace.invalidSize").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("wordsSize", words.length).var("replacementsSize", replacements.length).format());
        }
        int size = words.length;
        for (int i = 0; i < size; ++i) {
            replacer.register(words[i], replacements[i]);
        }
        if (anno.provider().length > 0) {
            ReplacedWordProvider provider = (ReplacedWordProvider)config.getBeanFactory().create(anno.provider()[0]);
            provider.getReplacedWords(field).stream().forEach(word -> replacer.register(word.getWord(), word.getReplacement()));
        }
        if (words.length == 0 && anno.provider().length == 0) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.required").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "value or provider").format());
        }
        replacer.ready();
        WordReplace processor = next.map(n -> new WordReplace(replacer, (StringCellProcessor)n)).orElseGet(() -> new WordReplace(replacer));
        return Optional.of(processor);
    }
}

