/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class OneSideTrim
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final char trimChar;
    private final boolean leftAlign;

    public OneSideTrim(char trimChar, boolean leftAlign) {
        this.trimChar = trimChar;
        this.leftAlign = leftAlign;
    }

    public OneSideTrim(char trimChar, boolean leftAlign, StringCellProcessor next) {
        super((CellProcessor)next);
        this.trimChar = trimChar;
        this.leftAlign = leftAlign;
    }

    public <T> T execute(Object value, CsvContext context) {
        if (value == null) {
            return (T)this.next.execute(value, context);
        }
        String result = this.trim(value.toString());
        return (T)this.next.execute((Object)result, context);
    }

    private String trim(String str) {
        int length = str.length();
        if (length == 0) {
            return str;
        }
        if (this.leftAlign) {
            if (str.charAt(0) != this.trimChar) {
                return str;
            }
            for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (c == this.trimChar) continue;
                return str.substring(i);
            }
            return "";
        }
        if (str.charAt(length - 1) != this.trimChar) {
            return str;
        }
        for (int i = length - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (c == this.trimChar) continue;
            return str.substring(0, i + 1);
        }
        return "";
    }

    public char getTrimChar() {
        return this.trimChar;
    }

    public boolean isLeftAlign() {
        return this.leftAlign;
    }
}

