/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class NullConvert
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final Set<String> tokens = new HashSet<String>();
    private final boolean ignoreCase;

    public NullConvert(Collection<String> tokens, boolean ignoreCase) {
        NullConvert.checkPreconditions(tokens);
        this.tokens.addAll(NullConvert.toIgnoreCase(tokens, ignoreCase));
        this.ignoreCase = ignoreCase;
    }

    public NullConvert(Collection<String> tokens, boolean ignoreCase, StringCellProcessor next) {
        super((CellProcessor)next);
        NullConvert.checkPreconditions(tokens);
        this.tokens.addAll(NullConvert.toIgnoreCase(tokens, ignoreCase));
        this.ignoreCase = ignoreCase;
    }

    private static void checkPreconditions(Collection<String> tokens) {
        if (tokens == null) {
            throw new NullPointerException("tokens should not be null.");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("tokens should not be empty.");
        }
    }

    private static Collection<String> toIgnoreCase(Collection<String> value, boolean ignoreCase) {
        if (!ignoreCase) {
            return value;
        }
        return value.stream().map(v -> v.toLowerCase()).collect(Collectors.toList());
    }

    private static String toIgnoreCase(String value, boolean ignoreCase) {
        if (!ignoreCase) {
            return value;
        }
        return value.toLowerCase();
    }

    public <T> T execute(Object value, CsvContext context) {
        if (value == null) {
            return (T)this.next.execute(value, context);
        }
        String str = NullConvert.toIgnoreCase(value.toString(), this.ignoreCase);
        if (this.tokens.contains(str)) {
            return (T)this.next.execute(null, context);
        }
        return (T)this.next.execute(value, context);
    }

    public Set<String> getTokens() {
        return this.tokens;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }
}

