/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.cellprocessor.conversion.CharCategory;
import com.github.mygreen.supercsv.cellprocessor.conversion.JapaneseCharReplacer;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class HalfChar
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final CharCategory[] categories;
    private final JapaneseCharReplacer replacer;

    public HalfChar(CharCategory[] categories) {
        HalfChar.checkPreconditions(categories);
        this.categories = categories;
        this.replacer = new JapaneseCharReplacer(categories);
    }

    public HalfChar(CharCategory[] categories, StringCellProcessor next) {
        super((CellProcessor)next);
        HalfChar.checkPreconditions(categories);
        this.categories = categories;
        this.replacer = new JapaneseCharReplacer(categories);
    }

    private static void checkPreconditions(CharCategory[] categories) {
        if (categories == null) {
            throw new NullPointerException("categories should not be null.");
        }
        if (categories.length == 0) {
            throw new IllegalArgumentException("categories should not be empty.");
        }
    }

    public <T> T execute(Object value, CsvContext context) {
        if (value == null) {
            return (T)this.next.execute(value, context);
        }
        String result = this.replacer.replaceToHalfChar(value.toString());
        return (T)this.next.execute((Object)result, context);
    }

    public CharCategory[] getCategories() {
        return this.categories;
    }
}

