/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.util.ArgUtils;
import com.github.mygreen.supercsv.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CharReplacer {
    private final Map<Character, String> singles = new HashMap<Character, String>();
    private final List<MultiChar> multi = new ArrayList<MultiChar>();

    public void register(String word, String replacement) {
        ArgUtils.notEmpty(word, "word");
        ArgUtils.notNull(replacement, "replacement");
        if (word.length() == 1) {
            this.singles.computeIfAbsent(Character.valueOf(word.charAt(0)), key -> replacement);
        } else {
            this.multi.add(new MultiChar(word, replacement));
        }
    }

    public void ready() {
        HashSet<String> duplicatedWords = new HashSet<String>();
        ArrayList<MultiChar> newMulti = new ArrayList<MultiChar>();
        for (MultiChar word : this.multi) {
            if (duplicatedWords.contains(word.word)) continue;
            duplicatedWords.add(word.word);
            newMulti.add(word);
        }
        Collections.sort(newMulti, new Comparator<MultiChar>(){

            @Override
            public int compare(MultiChar o1, MultiChar o2) {
                int length2;
                int length1 = o1.word.length();
                if (length1 < (length2 = o2.word.length())) {
                    return 1;
                }
                if (length1 > length2) {
                    return -1;
                }
                return o1.word.compareTo(o2.word);
            }
        });
        this.multi.clear();
        this.multi.addAll(newMulti);
    }

    public String replace(String text) {
        if (Utils.isEmpty(text)) {
            return text;
        }
        int length = text.length();
        StringBuilder replaced = new StringBuilder();
        int index = 0;
        while (index < length) {
            int multiIndex = this.replaceMulti(text, index, replaced);
            if (multiIndex > index) {
                index = multiIndex;
                continue;
            }
            int singleIndex = this.replaceSingle(text, index, replaced);
            if (singleIndex > index) {
                index = singleIndex;
                continue;
            }
            replaced.append(text.charAt(index));
            ++index;
        }
        return replaced.toString();
    }

    private int replaceSingle(String source, int index, StringBuilder replaced) {
        char c = source.charAt(index);
        if (this.singles.containsKey(Character.valueOf(c))) {
            replaced.append(this.singles.get(Character.valueOf(c)));
            return index + 1;
        }
        return index;
    }

    private int replaceMulti(String source, int index, StringBuilder replaced) {
        for (MultiChar word : this.multi) {
            if (source.indexOf(word.word, index) != index) continue;
            replaced.append(word.replacement);
            return index + word.word.length();
        }
        return index;
    }

    private static class MultiChar {
        private final String word;
        private final String replacement;

        private MultiChar(String word, String replacement) {
            this.word = word;
            this.replacement = replacement;
        }
    }
}

