/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class WordRequire
extends ValidationCellProcessor
implements StringCellProcessor {
    private final Collection<String> words;

    public WordRequire(Collection<String> words) {
        WordRequire.checkPreconditions(words);
        this.words = words.stream().distinct().collect(Collectors.toList());
    }

    public WordRequire(Collection<String> words, CellProcessor next) {
        super(next);
        WordRequire.checkPreconditions(words);
        this.words = words.stream().distinct().collect(Collectors.toList());
    }

    private static void checkPreconditions(Collection<String> words) {
        if (words == null) {
            throw new NullPointerException("words and field should not be null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        if (!this.words.isEmpty()) {
            String stringValue = value.toString();
            List requiredWords = this.words.stream().filter(word -> !stringValue.contains((CharSequence)word)).collect(Collectors.toList());
            if (!requiredWords.isEmpty()) {
                String joinedWords = String.join((CharSequence)", ", requiredWords);
                throw this.createValidationException(context).messageFormat("'%s' does not contain any of the required substirng '%s'", stringValue, joinedWords).rejectedValue(stringValue).messageVariables("words", requiredWords).build();
            }
        }
        return this.next.execute(value, context);
    }

    public Collection<String> getWords() {
        return this.words;
    }
}

