/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class Require
extends ValidationCellProcessor
implements BoolCellProcessor,
DateCellProcessor,
DoubleCellProcessor,
LongCellProcessor,
StringCellProcessor {
    private final boolean considerEmpty;
    private final boolean considerBlank;

    public Require(boolean considerEmpty, boolean considerBlank) {
        this.considerEmpty = considerEmpty;
        this.considerBlank = considerBlank;
    }

    public Require(boolean considerEmpty, boolean considerBlank, CellProcessor next) {
        super(next);
        this.considerEmpty = considerEmpty;
        this.considerBlank = considerBlank;
    }

    public <T> T execute(Object value, CsvContext context) {
        if (!this.validate(value)) {
            throw this.createValidationException(context).message("null or empty value encountered").messageVariables("considerEmpty", this.considerEmpty).messageVariables("considerBlank", this.considerBlank).rejectedValue(value).build();
        }
        return (T)this.next.execute(value, context);
    }

    private boolean validate(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            if (this.considerEmpty && strValue.isEmpty()) {
                return false;
            }
            if (this.considerBlank && strValue.trim().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public boolean isConsiderEmpty() {
        return this.considerEmpty;
    }

    public boolean isConsiderBlank() {
        return this.considerBlank;
    }
}

