/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class Pattern
extends ValidationCellProcessor
implements StringCellProcessor {
    private final java.util.regex.Pattern pattern;
    private final String description;

    public Pattern(java.util.regex.Pattern regexPattern, String regexDescriptoin) {
        Pattern.checkPreconditions(regexPattern);
        this.pattern = regexPattern;
        this.description = regexDescriptoin;
    }

    public Pattern(java.util.regex.Pattern regexPattern, String regexDescriptoin, StringCellProcessor next) {
        super((CellProcessor)next);
        Pattern.checkPreconditions(regexPattern);
        this.pattern = regexPattern;
        this.description = regexDescriptoin;
    }

    private static void checkPreconditions(java.util.regex.Pattern regexPattern) {
        if (regexPattern == null) {
            throw new NullPointerException("regexPattern should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        boolean matches = this.pattern.matcher((String)value).matches();
        if (!matches) {
            throw this.createValidationException(context).messageFormat("'%s' does not match the regular expression '%s'", value, this.getRegex()).rejectedValue(value).messageVariables("regex", this.getRegex()).messageVariables("flags", this.getFlags()).messageVariables("description", this.getDescription()).build();
        }
        return this.next.execute(value, context);
    }

    public String getRegex() {
        return this.pattern.pattern();
    }

    public int getFlags() {
        return this.pattern.flags();
    }

    public String getDescription() {
        return this.description;
    }
}

