/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvNumberRange;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.NumberRange;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class NumberRangeFactory<N extends Number>
implements ConstraintProcessorFactory<CsvNumberRange> {
    @Override
    public Optional<CellProcessor> create(CsvNumberRange anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        Number max;
        Number min;
        TextFormatter<?> typeFormatter = formatter;
        try {
            min = (Number)typeFormatter.parse(anno.min());
        }
        catch (TextParseException e) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.invalidType").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "min").var("attrValue", anno.min()).varWithClass("type", field.getType()).var("pattern", typeFormatter.getPattern().orElseGet(null)).format(true), e);
        }
        try {
            max = (Number)typeFormatter.parse(anno.max());
        }
        catch (TextParseException e) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.invalidType").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "max").var("attrValue", anno.max()).varWithClass("type", field.getType()).var("pattern", typeFormatter.getPattern().orElseGet(null)).format(true), e);
        }
        if (((Comparable)((Object)min)).compareTo(max) > 0) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.CsvNumberRange.minMaxWrong").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("minValue", anno.min()).var("maxValue", anno.max()).format(true));
        }
        NumberRange processor = next.map(n -> new NumberRange<Number>(min, max, anno.inclusive(), (TextPrinter<Number>)typeFormatter, (CellProcessor)n)).orElseGet(() -> new NumberRange<Number>(min, max, anno.inclusive(), typeFormatter));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

