/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class NumberRange<T extends Number>
extends ValidationCellProcessor
implements LongCellProcessor,
DoubleCellProcessor {
    private final T min;
    private final T max;
    private final boolean inclusive;
    private final TextPrinter<T> printer;

    public NumberRange(T min, T max, boolean inclusive, TextPrinter<T> printer) {
        NumberRange.checkPreconditions(min, max, printer);
        this.min = min;
        this.max = max;
        this.inclusive = inclusive;
        this.printer = printer;
    }

    public NumberRange(T min, T max, boolean inclusive, TextPrinter<T> printer, CellProcessor next) {
        super(next);
        NumberRange.checkPreconditions(min, max, printer);
        this.min = min;
        this.max = max;
        this.inclusive = inclusive;
        this.printer = printer;
    }

    private static <T extends Number> void checkPreconditions(T min, T max, TextPrinter<T> printer) {
        if (min == null || max == null || printer == null) {
            throw new NullPointerException("min ,max and printer should not be null");
        }
        if (((Comparable)((Object)min)).compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("max (%s) should not be < min (%s)", max, min));
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        Class<?> exepectedClass = this.getMin().getClass();
        if (!exepectedClass.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(exepectedClass, value, context, (CellProcessor)this);
        }
        Number result = (Number)value;
        if (!this.validate(result)) {
            throw this.createValidationException(context).messageFormat("%s does not lie between the min (%s) and max (%s) value.", this.printValue(result), this.printValue(this.min), this.printValue(this.max)).rejectedValue(result).messageVariables("min", this.getMin()).messageVariables("max", this.getMax()).messageVariables("inclusive", this.isInclusive()).messageVariables("printer", this.getPrinter()).build();
        }
        return this.next.execute((Object)result, context);
    }

    private boolean validate(T value) {
        int comparedMin = ((Comparable)value).compareTo(this.min);
        int comparedMax = ((Comparable)value).compareTo(this.max);
        if (comparedMin > 0 && comparedMax < 0) {
            return true;
        }
        return this.inclusive && (comparedMin == 0 || comparedMax == 0);
    }

    private String printValue(T value) {
        return this.getPrinter().print(value);
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public TextPrinter<T> getPrinter() {
        return this.printer;
    }
}

