/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvNumberMin;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.NumberMin;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class NumberMinFactory<N extends Number>
implements ConstraintProcessorFactory<CsvNumberMin> {
    @Override
    public Optional<CellProcessor> create(CsvNumberMin anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        Number min;
        TextFormatter<?> typeFormatter = formatter;
        try {
            min = (Number)typeFormatter.parse(anno.value());
        }
        catch (TextParseException e) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.invalidType").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "value").var("attrValue", anno.value()).varWithClass("type", field.getType()).var("pattern", typeFormatter.getPattern().orElseGet(null)).format(true), e);
        }
        NumberMin processor = next.map(n -> new NumberMin<Number>(min, anno.inclusive(), (TextPrinter<Number>)typeFormatter, (CellProcessor)n)).orElseGet(() -> new NumberMin<Number>(min, anno.inclusive(), typeFormatter));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

