/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvLengthMin;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.LengthMin;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class LengthMinFactory
implements ConstraintProcessorFactory<CsvLengthMin> {
    @Override
    public Optional<CellProcessor> create(CsvLengthMin anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        int min = anno.value();
        if (min < 0) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.min").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "value").var("attrValue", min).var("min", 0).format());
        }
        LengthMin processor = next.map(n -> new LengthMin(min, (CellProcessor)n)).orElseGet(() -> new LengthMin(min));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

