/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class LengthMax
extends ValidationCellProcessor
implements StringCellProcessor {
    private final int max;

    public LengthMax(int max) {
        LengthMax.checkPreconditions(max);
        this.max = max;
    }

    public LengthMax(int max, CellProcessor next) {
        super(next);
        LengthMax.checkPreconditions(max);
        this.max = max;
    }

    private static void checkPreconditions(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException(String.format("max length (%d) should not be <= 0", max));
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        String stringValue = value.toString();
        int length = stringValue.length();
        if (length > this.max) {
            throw this.createValidationException(context).messageFormat("the length (%d) of value '%s' does not lie the max (%d) values (inclusive)", length, stringValue, this.max).rejectedValue(stringValue).messageVariables("max", this.getMax()).messageVariables("length", length).build();
        }
        return this.next.execute((Object)stringValue, context);
    }

    public int getMax() {
        return this.max;
    }
}

