/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvLengthExact;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.LengthExact;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class LengthExactFactory
implements ConstraintProcessorFactory<CsvLengthExact> {
    @Override
    public Optional<CellProcessor> create(CsvLengthExact anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        List requriedLength = Arrays.stream(anno.value()).filter(l -> l >= 0).sorted().distinct().boxed().collect(Collectors.toList());
        if (requriedLength.isEmpty()) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.required").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "value").format());
        }
        LengthExact processor = next.map(n -> new LengthExact(requriedLength, (CellProcessor)n)).orElseGet(() -> new LengthExact(requriedLength));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

