/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.util.Utils;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class LengthExact
extends ValidationCellProcessor
implements StringCellProcessor {
    private final Set<Integer> requriedLengths = new TreeSet<Integer>();

    public LengthExact(Collection<Integer> requriedLengths) {
        LengthExact.checkPreconditions(requriedLengths);
        this.requriedLengths.addAll(requriedLengths);
    }

    public LengthExact(Collection<Integer> requriedLengths, CellProcessor next) {
        super(next);
        LengthExact.checkPreconditions(requriedLengths);
        this.requriedLengths.addAll(requriedLengths);
    }

    private static void checkPreconditions(Collection<Integer> requriedLengths) {
        if (requriedLengths == null) {
            throw new NullPointerException("requriedLengths should not be null");
        }
        if (requriedLengths.isEmpty()) {
            throw new IllegalArgumentException("requriedLengths should not be empty");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        String stringValue = value.toString();
        int length = stringValue.length();
        if (!this.requriedLengths.contains(length)) {
            String joinedLength = this.requriedLengths.stream().map(String::valueOf).collect(Collectors.joining(", "));
            throw this.createValidationException(context).messageFormat("the length (%d) of value '%s' not any of required lengths (%s)", length, stringValue, joinedLength).rejectedValue(stringValue).messageVariables("length", length).messageVariables("requiredLengths", this.getRequiredLengths()).build();
        }
        return this.next.execute((Object)stringValue, context);
    }

    public int[] getRequiredLengths() {
        return Utils.toArray(this.requriedLengths);
    }
}

