/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvLengthBetween;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.LengthBetween;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class LengthBetweenFactory
implements ConstraintProcessorFactory<CsvLengthBetween> {
    @Override
    public Optional<CellProcessor> create(CsvLengthBetween anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        int max;
        int min = anno.min();
        if (min > (max = anno.max())) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.CsvLengthBetween.minMaxWrong").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("minValue", min).var("maxValue", max).format());
        }
        if (min < 0) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.min").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "min").var("attrValue", min).var("min", 0).format());
        }
        LengthBetween processor = next.map(n -> new LengthBetween(min, max, (CellProcessor)n)).orElseGet(() -> new LengthBetween(min, max));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

