/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeRange;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeRange;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class DateTimeRangeFactory<T extends Comparable<T>>
implements ConstraintProcessorFactory<CsvDateTimeRange> {
    @Override
    public Optional<CellProcessor> create(CsvDateTimeRange anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        Comparable max;
        Comparable min;
        TextFormatter<?> typeFormatter = formatter;
        try {
            min = (Comparable)typeFormatter.parse(anno.min());
        }
        catch (TextParseException e) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.invalidType").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "min").var("attrValue", anno.min()).varWithClass("type", field.getType()).var("pattern", typeFormatter.getPattern().orElseGet(null)).format(true), e);
        }
        try {
            max = (Comparable)typeFormatter.parse(anno.max());
        }
        catch (TextParseException e) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.invalidType").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "max").var("attrValue", anno.max()).varWithClass("type", field.getType()).var("pattern", typeFormatter.getPattern().orElseGet(null)).format(true), e);
        }
        if (min.compareTo(max) > 0) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.CsvDateTimeRange.minMaxWrong").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("minValue", anno.min()).var("maxValue", anno.max()).format(true));
        }
        DateTimeRange processor = next.map(n -> new DateTimeRange<Comparable>(min, max, anno.inclusive(), (TextPrinter<Comparable>)typeFormatter, (CellProcessor)n)).orElseGet(() -> new DateTimeRange<Comparable>(min, max, anno.inclusive(), typeFormatter));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

