/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder.joda;

import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeMax;
import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeMin;
import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeRange;
import com.github.mygreen.supercsv.annotation.format.CsvDateTimeFormat;
import com.github.mygreen.supercsv.builder.AbstractProcessorBuilder;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeMaxFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeMinFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeRangeFactory;
import com.github.mygreen.supercsv.cellprocessor.format.JodaFormatWrapper;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.util.Utils;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.LenientChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractJodaProcessorBuilder<T>
extends AbstractProcessorBuilder<T> {
    @Override
    protected void init() {
        super.init();
        this.registerForConstraint(CsvDateTimeRange.class, new DateTimeRangeFactory());
        this.registerForConstraint(CsvDateTimeMin.class, new DateTimeMinFactory());
        this.registerForConstraint(CsvDateTimeMax.class, new DateTimeMaxFactory());
    }

    protected DateTimeFormatter createFormatter(FieldAccessor field, Configuration config) {
        Optional<CsvDateTimeFormat> formatAnno = field.getAnnotation(CsvDateTimeFormat.class);
        if (!formatAnno.isPresent()) {
            return DateTimeFormat.forPattern((String)this.getDefaultPattern());
        }
        String pattern = formatAnno.get().pattern();
        if (pattern.isEmpty()) {
            pattern = this.getDefaultPattern();
        }
        Locale locale = Utils.getLocale(formatAnno.get().locale());
        DateTimeZone zone = formatAnno.get().timezone().isEmpty() ? DateTimeZone.getDefault() : DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(formatAnno.get().timezone()));
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern).withLocale(locale).withZone(zone);
        boolean lenient = formatAnno.get().lenient();
        if (lenient) {
            LenientChronology chronology = LenientChronology.getInstance((Chronology)ISOChronology.getInstance());
            return formatter.withChronology((Chronology)chronology);
        }
        return formatter;
    }

    @Override
    protected TextFormatter<T> getDefaultFormatter(FieldAccessor field, Configuration config) {
        Optional<CsvDateTimeFormat> formatAnno = field.getAnnotation(CsvDateTimeFormat.class);
        String pattern = this.getPattern(field);
        DateTimeFormatter formatter = this.createFormatter(field, config);
        JodaFormatWrapper wrapper = new JodaFormatWrapper(formatter, field.getType());
        wrapper.setPattern(pattern);
        formatAnno.ifPresent(a -> wrapper.setValidationMessage(a.message()));
        return wrapper;
    }

    protected String getPattern(FieldAccessor field) {
        return field.getAnnotation(CsvDateTimeFormat.class).map(a -> a.pattern()).filter(p -> !p.isEmpty()).orElse(this.getDefaultPattern());
    }

    protected abstract String getDefaultPattern();
}

