/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.builder.BeanFactory;
import com.github.mygreen.supercsv.builder.DefaultBeanFactory;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public class SpringBeanFactory
implements BeanFactory<Class<?>, Object>,
ApplicationContextAware,
InitializingBean {
    private AutowireCapableBeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private BeanFactory<Class<?>, Object> defaultBeanFactory = new DefaultBeanFactory();

    @Override
    public Object create(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz should not be null.");
        String beanName = this.getBeanName(clazz);
        if (this.beanFactory.containsBean(beanName)) {
            return this.beanFactory.getBean(beanName, clazz);
        }
        Object obj = this.defaultBeanFactory.create(clazz);
        this.beanFactory.autowireBean(obj);
        return obj;
    }

    private String getBeanName(Class<?> clazz) {
        Component componentAnno = clazz.getAnnotation(Component.class);
        if (componentAnno != null && !componentAnno.value().isEmpty()) {
            return componentAnno.value();
        }
        Service serviceAnno = clazz.getAnnotation(Service.class);
        if (serviceAnno != null && !serviceAnno.value().isEmpty()) {
            return serviceAnno.value();
        }
        Repository repositoryAnno = clazz.getAnnotation(Repository.class);
        if (repositoryAnno != null && !repositoryAnno.value().isEmpty()) {
            return repositoryAnno.value();
        }
        Controller controllerAnno = clazz.getAnnotation(Controller.class);
        if (controllerAnno != null && !controllerAnno.value().isEmpty()) {
            return controllerAnno.value();
        }
        String simpleName = SpringBeanFactory.uncapitalize(clazz.getSimpleName());
        String[] names = this.applicationContext.getBeanNamesForType(clazz);
        if (names.length == 0) {
            return simpleName;
        }
        for (String name : names) {
            if (!name.equals(simpleName)) continue;
            return name;
        }
        return names[0];
    }

    private static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(String.valueOf(str.charAt(0)).toLowerCase()).append(str.substring(1)).toString();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.applicationContext != null && this.beanFactory == null) {
            this.beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

