/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.builder.ProcessorBuilder;
import com.github.mygreen.supercsv.builder.joda.DateTimeProcessorBuilder;
import com.github.mygreen.supercsv.builder.joda.LocalDateTimeProcessorBuilder;
import com.github.mygreen.supercsv.builder.joda.LocalTimeProcessorBuilder;
import com.github.mygreen.supercsv.builder.joda.MonthDayProcessorBuilder;
import com.github.mygreen.supercsv.builder.joda.YearMonthProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.BigDecimalProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.BigIntegerProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.BooleanProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.ByteProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.CalendarProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.CharacterProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.DateProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.DoubleProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.EnumProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.FloatProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.IntegerProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.LongProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.ShortProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.SqlDateProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.StringProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.TimeProcessorBuilder;
import com.github.mygreen.supercsv.builder.standard.TimestampProcessorBuilder;
import com.github.mygreen.supercsv.builder.time.LocalDateProcessorBuilder;
import com.github.mygreen.supercsv.builder.time.OffsetDateTimeProcessorBuilder;
import com.github.mygreen.supercsv.builder.time.OffsetTimeProcessorBuilder;
import com.github.mygreen.supercsv.builder.time.YearProcessorBuilder;
import com.github.mygreen.supercsv.builder.time.ZonedDateTimeProcessorBuilder;
import com.github.mygreen.supercsv.util.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.MonthDay;

public class ProcessorBuilderResolver {
    private Map<Class<?>, ProcessorBuilder<?>> builderMap = new HashMap();

    public ProcessorBuilderResolver() {
        this.init();
    }

    public void init() {
        this.register(String.class, new StringProcessorBuilder());
        this.register(Character.class, new CharacterProcessorBuilder());
        this.register(Character.TYPE, new CharacterProcessorBuilder());
        this.register(Boolean.class, new BooleanProcessorBuilder());
        this.register(Boolean.TYPE, new BooleanProcessorBuilder());
        this.register(Byte.class, new ByteProcessorBuilder());
        this.register(Byte.TYPE, new ByteProcessorBuilder());
        this.register(Short.class, new ShortProcessorBuilder());
        this.register(Short.TYPE, new ShortProcessorBuilder());
        this.register(Integer.class, new IntegerProcessorBuilder());
        this.register(Integer.TYPE, new IntegerProcessorBuilder());
        this.register(Long.class, new LongProcessorBuilder());
        this.register(Long.TYPE, new LongProcessorBuilder());
        this.register(Float.class, new FloatProcessorBuilder());
        this.register(Float.TYPE, new FloatProcessorBuilder());
        this.register(Double.class, new DoubleProcessorBuilder());
        this.register(Double.TYPE, new DoubleProcessorBuilder());
        this.register(BigDecimal.class, new BigDecimalProcessorBuilder());
        this.register(BigInteger.class, new BigIntegerProcessorBuilder());
        this.register(Calendar.class, new CalendarProcessorBuilder());
        this.register(java.util.Date.class, new DateProcessorBuilder());
        this.register(Date.class, new SqlDateProcessorBuilder());
        this.register(Time.class, new TimeProcessorBuilder());
        this.register(Timestamp.class, new TimestampProcessorBuilder());
        this.register(Enum.class, new EnumProcessorBuilder());
        this.register(LocalDateTime.class, new com.github.mygreen.supercsv.builder.time.LocalDateTimeProcessorBuilder());
        this.register(LocalDate.class, new LocalDateProcessorBuilder());
        this.register(java.time.LocalTime.class, new com.github.mygreen.supercsv.builder.time.LocalTimeProcessorBuilder());
        this.register(ZonedDateTime.class, new ZonedDateTimeProcessorBuilder());
        this.register(OffsetDateTime.class, new OffsetDateTimeProcessorBuilder());
        this.register(OffsetTime.class, new OffsetTimeProcessorBuilder());
        this.register(Year.class, new YearProcessorBuilder());
        this.register(YearMonth.class, new com.github.mygreen.supercsv.builder.time.YearMonthProcessorBuilder());
        this.register(java.time.MonthDay.class, new com.github.mygreen.supercsv.builder.time.MonthDayProcessorBuilder());
        if (Utils.isEnabledJodaTime()) {
            this.register(org.joda.time.LocalDateTime.class, new LocalDateTimeProcessorBuilder());
            this.register(org.joda.time.LocalDate.class, new com.github.mygreen.supercsv.builder.joda.LocalDateProcessorBuilder());
            this.register(LocalTime.class, new LocalTimeProcessorBuilder());
            this.register(DateTime.class, new DateTimeProcessorBuilder());
            this.register(org.joda.time.YearMonth.class, new YearMonthProcessorBuilder());
            this.register(MonthDay.class, new MonthDayProcessorBuilder());
        }
    }

    public <T> ProcessorBuilder<T> resolve(Class<T> type) {
        ProcessorBuilder<?> builder = this.builderMap.get(type);
        if (builder == null && Enum.class.isAssignableFrom(type)) {
            builder = this.builderMap.get(Enum.class);
        }
        return builder;
    }

    public <T> ProcessorBuilder<T> register(Class<T> type, ProcessorBuilder<T> builder) {
        return this.builderMap.put(type, builder);
    }
}

