/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.annotation.CsvBean;
import com.github.mygreen.supercsv.annotation.CsvColumn;
import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.builder.BeanMappingFactory;
import com.github.mygreen.supercsv.builder.ColumnMapping;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;

public class LazyBeanMappingFactory
extends BeanMappingFactory {
    @Override
    public <T> BeanMapping<T> create(Class<T> beanType, Class<?> ... groups) {
        Objects.requireNonNull(beanType);
        Configuration configuration = this.getConfiguration();
        BeanMapping<T> beanMapping = new BeanMapping<T>(beanType);
        beanMapping.setConfiguration(configuration);
        CsvBean beanAnno = beanType.getAnnotation(CsvBean.class);
        if (beanAnno == null) {
            throw new SuperCsvInvalidAnnotationException(beanAnno, MessageBuilder.create("anno.notFound").varWithClass("property", beanType).varWithAnno("anno", CsvBean.class).format());
        }
        this.buildHeaderMapper(beanMapping, beanAnno);
        this.buildValidators(beanMapping, beanAnno, groups);
        this.buildColumnMappingList(beanMapping, beanType, groups);
        this.buildCallbackMethods(beanMapping, beanType, beanAnno);
        return beanMapping;
    }

    @Override
    protected <T> void buildColumnMappingList(BeanMapping<T> beanMapping, Class<T> beanType, Class<?>[] groups) {
        ArrayList<ColumnMapping> columnMappingList = new ArrayList<ColumnMapping>();
        for (Field field : beanType.getDeclaredFields()) {
            CsvColumn columnAnno = field.getAnnotation(CsvColumn.class);
            if (columnAnno == null) continue;
            columnMappingList.add(this.createColumnMapping(field, columnAnno, groups));
        }
        beanMapping.addAllColumns(columnMappingList);
    }
}

