/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.annotation.DefaultGroup;
import com.github.mygreen.supercsv.builder.AnnotationExpander;
import com.github.mygreen.supercsv.builder.ExpandedAnnotation;
import com.github.mygreen.supercsv.util.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.supercsv.exception.SuperCsvReflectionException;

public class FieldAccessor {
    private final Field field;
    private final String name;
    private final Class<?> type;
    private final List<ExpandedAnnotation> expandedAnnos = new ArrayList<ExpandedAnnotation>();

    public FieldAccessor(Field field, Comparator<Annotation> comparator) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(comparator);
        field.setAccessible(true);
        this.field = field;
        this.type = field.getType();
        this.name = field.getName();
        AnnotationExpander expander = new AnnotationExpander(comparator);
        this.expandedAnnos.addAll(expander.expand(field.getAnnotations()));
    }

    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annoClass) {
        Objects.requireNonNull(annoClass, "annoClass should not be null.");
        return FieldAccessor.getAnnotationsByType(this.expandedAnnos, annoClass).stream().findFirst();
    }

    public <A extends Annotation> List<A> getAnnotations(Class<A> annoClass) {
        Objects.requireNonNull(annoClass, "annoClass should not be null.");
        return FieldAccessor.getAnnotationsByType(this.expandedAnnos, annoClass);
    }

    private static <A extends Annotation> List<A> getAnnotationsByType(List<ExpandedAnnotation> expanedAnnos, Class<A> annoClass) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (ExpandedAnnotation anno : expanedAnnos) {
            if (anno.isAnnotationType(annoClass)) {
                list.add(anno.getOriginal());
                continue;
            }
            if (!anno.isComposed()) continue;
            list.addAll(FieldAccessor.getAnnotationsByType(anno.getChilds(), annoClass));
        }
        return list;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> annoClass) {
        return this.getAnnotation(annoClass).isPresent();
    }

    public <A extends Annotation> List<A> getAnnotationsByGroup(Class<A> annoClass, Class<?> ... groups) {
        Objects.requireNonNull(annoClass, "annoClass should not be null.");
        return this.getAnnotations(annoClass).stream().filter(anno -> this.hasGroups((Annotation)anno, groups)).collect(Collectors.toList());
    }

    public <A extends Annotation> boolean hasAnnotationByGroup(Class<A> annoClass, Class<?> ... groups) {
        return this.getAnnotationsByGroup(annoClass, groups).size() > 0;
    }

    public List<Annotation> getAnnotationsByGroup(Class<?> ... groups) {
        return FieldAccessor.getAnnotations(this.expandedAnnos).stream().filter(anno -> this.hasGroups((Annotation)anno, groups)).collect(Collectors.toList());
    }

    private static <A extends Annotation> List<A> getAnnotations(List<ExpandedAnnotation> expanedAnnos) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ExpandedAnnotation anno : expanedAnnos) {
            if (anno.isComposed()) {
                list.addAll(FieldAccessor.getAnnotations(anno.getChilds()));
                continue;
            }
            list.add(anno.getOriginal());
        }
        return list;
    }

    private boolean hasGroups(Annotation anno, Class<?> ... groups) {
        Optional<Class[]> targetGroups = Utils.getAnnotationAttribute(anno, "groups", Class[].class);
        if (!targetGroups.isPresent()) {
            return false;
        }
        if (groups.length == 0) {
            if (targetGroups.get().length == 0) {
                return true;
            }
            for (Class targetGroup : targetGroups.get()) {
                if (!targetGroup.equals(DefaultGroup.class)) continue;
                return true;
            }
        } else {
            for (Class<?> group : groups) {
                if (group.equals(DefaultGroup.class) && targetGroups.get().length == 0) {
                    return true;
                }
                for (Class targetGroup : targetGroups.get()) {
                    if (!targetGroup.equals(group)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithClass() {
        return this.getDeclaredClass().getName() + "#" + this.getName();
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.getType().getName();
    }

    public Class<?> getDeclaredClass() {
        return this.field.getDeclaringClass();
    }

    public boolean isTypeOf(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getType());
    }

    public Object getValue(Object record) {
        Objects.requireNonNull(record);
        if (!this.getDeclaredClass().equals(record.getClass())) {
            throw new IllegalArgumentException(String.format("not match record class type. expected=%s. actual=%s, ", this.type.getName(), record.getClass().getName()));
        }
        try {
            return this.field.get(record);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new SuperCsvReflectionException("fail get field value.", (Throwable)e);
        }
    }
}

