/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.builder.BeanFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.supercsv.exception.SuperCsvReflectionException;
import org.supercsv.util.BeanInterfaceProxy;

public class DefaultBeanFactory
implements BeanFactory<Class<?>, Object> {
    @Override
    public Object create(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz should not be null.");
        try {
            if (clazz.isInterface()) {
                return BeanInterfaceProxy.createProxy(clazz);
            }
            Class<?> declaredClass = clazz.getDeclaringClass();
            if (declaredClass != null && !Modifier.isStatic(clazz.getModifiers())) {
                Constructor<?> cons = clazz.getDeclaredConstructor(declaredClass);
                cons.setAccessible(true);
                return cons.newInstance(new Object[]{null});
            }
            Constructor<?> cons = clazz.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return cons.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new SuperCsvReflectionException(String.format("fail create Bean instance of '%s'", clazz.getName()), (Throwable)e);
        }
    }
}

