/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.validation.CsvBindingErrors;
import com.github.mygreen.supercsv.validation.ValidationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.supercsv.exception.SuperCsvReflectionException;
import org.supercsv.util.CsvContext;

public class CallbackMethod
implements Comparable<CallbackMethod> {
    protected final Method method;

    public CallbackMethod(Method method) {
        Objects.requireNonNull(method);
        method.setAccessible(true);
        this.method = method;
    }

    public void invoke(Object record, CsvContext csvContext, CsvBindingErrors bindingErrors, BeanMapping<?> beanMapping) {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Object[] paramValues = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramValues[i] = CsvContext.class.isAssignableFrom(paramTypes[i]) ? csvContext : (CsvBindingErrors.class.isAssignableFrom(paramTypes[i]) ? bindingErrors : (paramTypes[i].isArray() && Class.class.isAssignableFrom(paramTypes[i].getComponentType()) ? beanMapping.getGroups() : (ValidationContext.class.isAssignableFrom(paramTypes[i]) ? new ValidationContext(csvContext, beanMapping) : (beanMapping.getType().isAssignableFrom(paramTypes[i]) ? record : null))));
        }
        this.execute(record, paramValues);
    }

    protected void execute(Object record, Object[] paramValues) {
        try {
            this.method.invoke(record, paramValues);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            throw new SuperCsvReflectionException(String.format("Fail execute method '%s#%s'.", record.getClass().getName(), this.method.getName()), t);
        }
    }

    @Override
    public int compareTo(CallbackMethod o) {
        String name1 = this.method.getDeclaringClass().getName() + "#" + this.method.getName();
        String name2 = o.method.getDeclaringClass().getName() + "#" + o.method.getName();
        return name1.compareTo(name2);
    }
}

