/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.annotation.CsvColumn;
import com.github.mygreen.supercsv.annotation.CsvPartial;
import com.github.mygreen.supercsv.builder.ColumnMapping;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.supercsv.exception.SuperCsvException;

public class BeanMappingFactoryHelper {
    public static TreeSet<Integer> validateDuplicatedColumnNumber(Class<?> beanType, List<ColumnMapping> list) {
        TreeSet<Integer> checkedNumber = new TreeSet<Integer>();
        TreeSet<Integer> duplicatedNumbers = new TreeSet<Integer>();
        for (ColumnMapping columnMapping : list) {
            if (checkedNumber.contains(columnMapping.getNumber())) {
                duplicatedNumbers.add(columnMapping.getNumber());
            }
            checkedNumber.add(columnMapping.getNumber());
        }
        if (!duplicatedNumbers.isEmpty()) {
            throw new SuperCsvInvalidAnnotationException(MessageBuilder.create("anno.attr.duplicated").var("property", beanType.getName()).varWithAnno("anno", CsvColumn.class).var("attrName", "number").var("attrValues", duplicatedNumbers).format());
        }
        int minColumnNumber = (Integer)checkedNumber.first();
        if (minColumnNumber <= 0) {
            throw new SuperCsvInvalidAnnotationException(MessageBuilder.create("anno.attr.min").var("property", beanType.getName()).varWithAnno("anno", CsvColumn.class).var("attrName", "number").var("attrValue", minColumnNumber).var("min", 1).format());
        }
        return checkedNumber;
    }

    public static TreeSet<Integer> supplyLackedNumberMappingColumn(Class<?> beanType, List<ColumnMapping> list, Optional<CsvPartial> partialAnno, String[] suppliedHeaders) {
        TreeSet checkedNumber = list.stream().filter(col -> col.isDeterminedNumber()).map(col -> col.getNumber()).collect(Collectors.toCollection(TreeSet::new));
        int maxColumnNumber = (Integer)checkedNumber.last();
        TreeSet<Integer> lackedNumbers = new TreeSet<Integer>();
        for (int i = 1; i <= maxColumnNumber; ++i) {
            if (checkedNumber.contains(i)) continue;
            lackedNumbers.add(i);
        }
        if (partialAnno.isPresent()) {
            int partialColumnSize = partialAnno.get().columnSize();
            if (maxColumnNumber > partialColumnSize) {
                throw new SuperCsvInvalidAnnotationException(partialAnno.get(), MessageBuilder.create("anno.CsvPartial.columSizeMin").var("property", beanType.getName()).var("columnSize", partialColumnSize).var("maxColumnNumber", maxColumnNumber).format());
            }
            if (maxColumnNumber < partialColumnSize) {
                for (int i = maxColumnNumber + 1; i <= partialColumnSize; ++i) {
                    lackedNumbers.add(i);
                }
            }
        }
        if (lackedNumbers.size() > 0) {
            Iterator iterator = lackedNumbers.iterator();
            while (iterator.hasNext()) {
                int number = (Integer)iterator.next();
                list.add(BeanMappingFactoryHelper.createPartialColumnMapping(number, partialAnno, BeanMappingFactoryHelper.getSuppliedHeaders(suppliedHeaders, number)));
            }
            list.sort(null);
        }
        return lackedNumbers;
    }

    private static Optional<String> getSuppliedHeaders(String[] suppliedHeaders, int columnNumber) {
        int length = suppliedHeaders.length;
        if (length == 0) {
            return Optional.empty();
        }
        if (columnNumber < length) {
            return Optional.ofNullable(suppliedHeaders[columnNumber - 1]);
        }
        return Optional.empty();
    }

    private static ColumnMapping createPartialColumnMapping(int columnNumber, Optional<CsvPartial> partialAnno, Optional<String> suppliedHeader) {
        ColumnMapping columnMapping = new ColumnMapping();
        columnMapping.setNumber(columnNumber);
        columnMapping.setPartialized(true);
        String label = String.format("column%d", columnNumber);
        if (suppliedHeader.isPresent()) {
            label = suppliedHeader.get();
        }
        if (partialAnno.isPresent()) {
            for (CsvPartial.Header header : partialAnno.get().headers()) {
                if (header.number() != columnNumber) continue;
                label = header.label();
                break;
            }
        }
        columnMapping.setLabel(label);
        return columnMapping;
    }

    public static void validateNonDeterminedColumnNumber(Class<?> beanType, List<ColumnMapping> list, String[] headers) {
        List nonDeterminedLabels = list.stream().filter(col -> !col.isDeterminedNumber()).map(col -> col.getLabel()).collect(Collectors.toList());
        if (!nonDeterminedLabels.isEmpty()) {
            throw new SuperCsvException(MessageBuilder.create("lazy.noDeteminedColumns").var("property", beanType.getName()).var("labels", nonDeterminedLabels).var("headers", headers).format());
        }
    }
}

