/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.builder.CallbackMethod;
import com.github.mygreen.supercsv.builder.ColumnMapping;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.HeaderMapper;
import com.github.mygreen.supercsv.validation.CsvValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class BeanMapping<T> {
    private final Class<T> type;
    private boolean header;
    private boolean validateHeader;
    private List<CsvValidator<T>> validators = new ArrayList<CsvValidator<T>>();
    private List<Object> listeners = new ArrayList<Object>();
    private List<ColumnMapping> columns = new ArrayList<ColumnMapping>();
    private List<CallbackMethod> preReadMethods = new ArrayList<CallbackMethod>();
    private List<CallbackMethod> postReadMethods = new ArrayList<CallbackMethod>();
    private List<CallbackMethod> preWriteMethods = new ArrayList<CallbackMethod>();
    private List<CallbackMethod> postWriteMethods = new ArrayList<CallbackMethod>();
    private boolean skipValidationOnWrite;
    private Class<?>[] groups;
    private HeaderMapper headerMapper;
    private Configuration configuration;

    public BeanMapping(Class<T> type) {
        this.type = type;
    }

    public Optional<ColumnMapping> getColumnMapping(int columnNumber) {
        return this.columns.stream().filter(c -> c.getNumber() == columnNumber).findFirst();
    }

    public Optional<ColumnMapping> getColumnMapping(String columnName) {
        return this.columns.stream().filter(c -> c.getName() != null && c.getName().equals(columnName)).findFirst();
    }

    public String[] getHeader() {
        return (String[])this.columns.stream().map(c -> this.headerMapper.toMap((ColumnMapping)c, this.configuration, this.groups)).toArray(String[]::new);
    }

    public String[] getNameMapping() {
        return (String[])this.columns.stream().map(c -> c.getName()).toArray(String[]::new);
    }

    public CellProcessor[] getCellProcessorsForReading() {
        return (CellProcessor[])this.columns.stream().map(c -> c.getCellProcessorForReading()).toArray(CellProcessor[]::new);
    }

    public CellProcessor[] getCellProcessorsForWriting() {
        return (CellProcessor[])this.columns.stream().map(c -> c.getCellProcessorForWriting()).toArray(CellProcessor[]::new);
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public boolean isValidateHeader() {
        return this.validateHeader;
    }

    public void setValidateHeader(boolean validateHeader) {
        this.validateHeader = validateHeader;
    }

    public List<CsvValidator<T>> getValidators() {
        return this.validators;
    }

    public void addAllValidators(List<CsvValidator<T>> validators) {
        this.validators.addAll(validators);
    }

    public List<Object> getListeners() {
        return this.listeners;
    }

    public void addAllListeners(List<Object> listeners) {
        this.listeners.addAll(listeners);
    }

    public List<ColumnMapping> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnMapping> columns) {
        this.columns = columns;
    }

    public void addAllColumns(List<ColumnMapping> columns) {
        this.columns.addAll(columns);
    }

    public List<CallbackMethod> getPreReadMethods() {
        return this.preReadMethods;
    }

    public void addPreReadMethod(CallbackMethod method) {
        this.preReadMethods.add(method);
    }

    public List<CallbackMethod> getPostReadMethods() {
        return this.postReadMethods;
    }

    public void addPostReadMethod(CallbackMethod method) {
        this.postReadMethods.add(method);
    }

    public List<CallbackMethod> getPreWriteMethods() {
        return this.preWriteMethods;
    }

    public void addPreWriteMethod(CallbackMethod method) {
        this.preWriteMethods.add(method);
    }

    public List<CallbackMethod> getPostWriteMethods() {
        return this.postWriteMethods;
    }

    public void addPostWriteMethod(CallbackMethod method) {
        this.postWriteMethods.add(method);
    }

    public boolean isSkipValidationOnWrite() {
        return this.skipValidationOnWrite;
    }

    public void setSkipValidationOnWrite(boolean skipValidationOnWrite) {
        this.skipValidationOnWrite = skipValidationOnWrite;
    }

    public Class<?>[] getGroups() {
        return this.groups;
    }

    public void setGroups(Class<?>[] groups) {
        this.groups = groups;
    }

    public HeaderMapper getHeaderMapper() {
        return this.headerMapper;
    }

    public void setHeaderMapper(HeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuraton) {
        this.configuration = configuraton;
    }
}

