/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.util;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class SimpleDateFormatBuilder {
    private String pattern;
    private Locale locale;
    private TimeZone timeZone;
    private boolean lenient;

    public static SimpleDateFormatBuilder create(String pattern) {
        return new SimpleDateFormatBuilder(pattern);
    }

    private SimpleDateFormatBuilder(String pattern) {
        this.pattern = pattern;
        this.locale = Locale.getDefault();
        this.timeZone = TimeZone.getDefault();
        this.lenient = false;
    }

    public SimpleDateFormat build() {
        SimpleDateFormat formatter = this.locale != null ? new SimpleDateFormat(this.pattern) : new SimpleDateFormat(this.pattern, this.locale);
        if (this.timeZone != null) {
            formatter.setTimeZone(this.timeZone);
        }
        formatter.setLenient(this.lenient);
        return formatter;
    }

    public SimpleDateFormatBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public SimpleDateFormatBuilder timeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public SimpleDateFormatBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }
}

