/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormatWrapper {
    private final DateFormat formatter;

    public DateFormatWrapper(DateFormat formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter should not be null.");
        }
        this.formatter = (DateFormat)formatter.clone();
    }

    public DateFormatWrapper(Class<? extends Date> dateClass) {
        if (dateClass == null) {
            throw new NullPointerException("dateClass should not be null.");
        }
        String pattern = Timestamp.class.isAssignableFrom(dateClass) ? "yyyy-MM-dd HH:mm:ss.SSS" : (Time.class.isAssignableFrom(dateClass) ? "HH:mm:ss" : (java.sql.Date.class.isAssignableFrom(dateClass) ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss"));
        this.formatter = new SimpleDateFormat(pattern);
    }

    public synchronized <T extends Date> String format(T date) {
        return this.formatter.format(date);
    }

    public synchronized Date parse(String str) throws ParseException {
        return this.formatter.parse(str);
    }

    public String getPattern() {
        if (this.formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)this.formatter;
            return sdf.toPattern();
        }
        return null;
    }
}

