/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.io;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.exception.SuperCsvReflectionException;
import org.supercsv.ext.exception.SuperCsvNoMatchColumnSizeException;
import org.supercsv.ext.exception.SuperCsvRowException;
import org.supercsv.ext.localization.CsvExceptionConveter;
import org.supercsv.ext.localization.CsvMessage;
import org.supercsv.io.AbstractCsvReader;
import org.supercsv.io.ICsvBeanReader;
import org.supercsv.io.ITokenizer;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.BeanInterfaceProxy;
import org.supercsv.util.CsvContext;
import org.supercsv.util.MethodCache;

public class ValidatableCsvBeanReader
extends AbstractCsvReader
implements ICsvBeanReader {
    private final List<Object> processedColumns = new ArrayList<Object>();
    private final MethodCache cache = new MethodCache();
    protected CsvExceptionConveter exceptionConverter = new CsvExceptionConveter();
    private final List<CsvMessage> errors = new ArrayList<CsvMessage>();

    public CsvExceptionConveter getExceptionConverter() {
        return this.exceptionConverter;
    }

    public void setExceptionConverter(CsvExceptionConveter exceptionConverter) {
        this.exceptionConverter = exceptionConverter;
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public boolean hasNotError() {
        return !this.hasError();
    }

    public List<CsvMessage> getCsvErrors() {
        return this.errors;
    }

    public ValidatableCsvBeanReader(Reader reader, CsvPreference preferences) {
        super(reader, preferences);
    }

    public ValidatableCsvBeanReader(ITokenizer tokenizer, CsvPreference preferences) {
        super(tokenizer, preferences);
    }

    protected static <T> T instantiateBean(Class<T> clazz) {
        Object bean;
        if (clazz.isInterface()) {
            bean = BeanInterfaceProxy.createProxy(clazz);
        } else {
            try {
                bean = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new SuperCsvReflectionException(String.format("error instantiating bean, check that %s has a default no-args constructor", clazz.getName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SuperCsvReflectionException("error instantiating bean", (Throwable)e);
            }
        }
        return (T)bean;
    }

    private static void invokeSetter(Object bean, Method setMethod, Object fieldValue) {
        try {
            setMethod.invoke(bean, fieldValue);
        }
        catch (Exception e) {
            throw new SuperCsvReflectionException(String.format("error invoking method %s()", setMethod.getName()), (Throwable)e);
        }
    }

    protected <T> T populateBean(T resultBean, String[] nameMapping) {
        for (int i = 0; i < nameMapping.length; ++i) {
            Object fieldValue = this.processedColumns.get(i);
            if (nameMapping[i] == null || fieldValue == null) continue;
            Method setMethod = this.cache.getSetMethod(resultBean, nameMapping[i], fieldValue.getClass());
            ValidatableCsvBeanReader.invokeSetter(resultBean, setMethod, fieldValue);
        }
        return resultBean;
    }

    public <T> T read(T bean, String ... nameMapping) throws IOException {
        if (bean == null) {
            throw new NullPointerException("bean should not be null");
        }
        if (nameMapping == null) {
            throw new NullPointerException("nameMaping should not be null");
        }
        return this.readInfoBean(bean, nameMapping, null);
    }

    public <T> T read(T bean, String[] nameMapping, CellProcessor ... processors) throws IOException {
        if (bean == null) {
            throw new NullPointerException("bean should not be null");
        }
        if (nameMapping == null) {
            throw new NullPointerException("nameMaping should not be null");
        }
        return this.readInfoBean(bean, nameMapping, processors);
    }

    public <T> T read(Class<T> clazz, String ... nameMapping) throws IOException {
        if (clazz == null) {
            throw new NullPointerException("clazz should not be null");
        }
        if (nameMapping == null) {
            throw new NullPointerException("nameMapping should not be null");
        }
        return this.readInfoBean(ValidatableCsvBeanReader.instantiateBean(clazz), nameMapping, null);
    }

    public <T> T read(Class<T> clazz, String[] nameMapping, CellProcessor ... processors) throws IOException {
        if (clazz == null) {
            throw new NullPointerException("clazz should not be null");
        }
        if (nameMapping == null) {
            throw new NullPointerException("nameMapping should not be null");
        }
        if (processors == null) {
            throw new NullPointerException("processors should not be null");
        }
        return this.readInfoBean(ValidatableCsvBeanReader.instantiateBean(clazz), nameMapping, processors);
    }

    private <T> T readInfoBean(T bean, String[] nameMapping, CellProcessor[] processors) throws IOException {
        if (this.readRow()) {
            try {
                this.executeCellProcessors(this.processedColumns, this.getColumns(), processors, this.getLineNumber(), this.getRowNumber());
                return this.populateBean(bean, nameMapping);
            }
            catch (SuperCsvRowException e) {
                throw e;
            }
            catch (SuperCsvException e) {
                this.errors.addAll(this.exceptionConverter.convertCsvError(e, this.getDefinedHeader()));
                throw e;
            }
        }
        return null;
    }

    protected void executeCellProcessors(List<Object> destination, List<?> source, CellProcessor[] processors, int lineNo, int rowNo) {
        if (destination == null) {
            throw new NullPointerException("destination should not be null");
        }
        if (source == null) {
            throw new NullPointerException("source should not be null");
        }
        if (processors == null) {
            throw new NullPointerException("processors should not be null");
        }
        CsvContext context = new CsvContext(lineNo, rowNo, 1);
        context.setRowSource(new ArrayList(source));
        if (source.size() != processors.length) {
            throw new SuperCsvNoMatchColumnSizeException(source.size(), processors.length, context);
        }
        destination.clear();
        SuperCsvRowException columnError = new SuperCsvRowException(String.format("row (%d) has errors column", rowNo), context);
        for (int i = 0; i < source.size(); ++i) {
            try {
                context.setColumnNumber(i + 1);
                if (processors[i] == null) {
                    destination.add(source.get(i));
                    continue;
                }
                destination.add(processors[i].execute(source.get(i), context));
                continue;
            }
            catch (SuperCsvCellProcessorException e) {
                columnError.addError(e);
                this.errors.addAll(this.exceptionConverter.convertCsvError(e, this.getDefinedHeader()));
                continue;
            }
            catch (SuperCsvException e) {
                columnError.addError(e);
                this.errors.addAll(this.exceptionConverter.convertCsvError(e, this.getDefinedHeader()));
            }
        }
        if (columnError.isNotEmptyColumnErrors()) {
            throw columnError;
        }
    }

    public String[] getDefinedHeader() {
        return null;
    }
}

