/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.constraint;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.ext.util.NumberFormatWrapper;
import org.supercsv.util.CsvContext;

public class Range<T extends Number>
extends CellProcessorAdaptor
implements LongCellProcessor,
DoubleCellProcessor,
ValidationCellProcessor {
    protected final T min;
    protected final T max;
    protected NumberFormat formatter;

    public Range(T min, T max) {
        Range.checkPreconditions(min, max);
        this.min = min;
        this.max = max;
    }

    public Range(T min, T max, CellProcessor next) {
        super(next);
        Range.checkPreconditions(min, max);
        this.min = min;
        this.max = max;
    }

    protected static <T extends Number> void checkPreconditions(T min, T max) {
        if (min == null || max == null) {
            throw new NullPointerException("min and max should not be null");
        }
        if (((Comparable)((Object)min)).compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("max (%s) should not be < min (%s)", max, min));
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        Class<?> exepectedClass = this.getMin().getClass();
        if (!exepectedClass.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(exepectedClass, value, context, (CellProcessor)this);
        }
        Number result = (Number)value;
        if (((Comparable)((Object)result)).compareTo(this.min) < 0 || ((Comparable)((Object)result)).compareTo(this.max) > 0) {
            throw new SuperCsvConstraintViolationException(String.format("%s does not lie between the min (%s) and max (%s) values (inclusive)", result, this.min, this.max), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, T> vars = new HashMap<String, T>();
        vars.put("min", this.getMin());
        vars.put("max", this.getMax());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (this.getFormatter() != null) {
                return new NumberFormatWrapper(this.getFormatter()).format(number);
            }
        }
        return value.toString();
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public NumberFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(NumberFormat formatter) {
        this.formatter = formatter;
    }
}

